/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.fork.Fork;
import org.takes.misc.EnglishLowerCase;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;

public final class FkEncoding
implements Fork {
    private static final Pattern ENCODING_SEP = Pattern.compile("\\s*,\\s*");
    private final String encoding;
    private final Response origin;

    public FkEncoding(String enc, Response response) {
        this.encoding = new EnglishLowerCase(enc.trim()).string();
        this.origin = response;
    }

    @Override
    public Opt<Response> route(Request req) throws IOException {
        List<String> items;
        Iterator<String> headers = new RqHeaders.Base(req).header("Accept-Encoding").iterator();
        Opt<Response> resp = this.encoding.isEmpty() ? new Opt.Single<Response>(this.origin) : (headers.hasNext() ? ((items = Arrays.asList(ENCODING_SEP.split(new EnglishLowerCase(headers.next().trim()).string()))).contains(this.encoding) ? new Opt.Single<Response>(this.origin) : new Opt.Empty()) : new Opt.Empty());
        return resp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkEncoding)) {
            return false;
        }
        FkEncoding other = (FkEncoding)o;
        String this$encoding = this.encoding;
        String other$encoding = other.encoding;
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        Response this$origin = this.origin;
        Response other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.encoding;
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        Response $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

