/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;

public final class FkHitRefresh
implements Fork {
    private final Runnable exec;
    private final Take take;
    private final HitRefreshHandle handle;

    public FkHitRefresh(File file, String cmd, Take tke) {
        this(file, Arrays.asList(cmd.split(" ")), tke);
    }

    public FkHitRefresh(File file, List<String> cmd, Take tke) {
        this(file, () -> {
            try {
                new ProcessBuilder(new String[0]).command(cmd).start();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }, tke);
    }

    public FkHitRefresh(File file, Runnable cmd, Take tke) {
        this(cmd, tke, new HitRefreshHandle(file));
    }

    private FkHitRefresh(Runnable cmd, Take tke, HitRefreshHandle handle) {
        this.exec = cmd;
        this.take = tke;
        this.handle = handle;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        Opt<Response> resp;
        Iterator<String> header = new RqHeaders.Base(req).header("X-Takes-HitRefresh").iterator();
        if (header.hasNext()) {
            if (this.handle.expired()) {
                this.exec.run();
                this.handle.touch();
            }
            resp = new Opt.Single<Response>(this.take.act(req));
        } else {
            resp = new Opt.Empty<Response>();
        }
        return resp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkHitRefresh)) {
            return false;
        }
        FkHitRefresh other = (FkHitRefresh)o;
        Runnable this$exec = this.exec;
        Runnable other$exec = other.exec;
        if (this$exec == null ? other$exec != null : !this$exec.equals(other$exec)) {
            return false;
        }
        Take this$take = this.take;
        Take other$take = other.take;
        if (this$take == null ? other$take != null : !this$take.equals(other$take)) {
            return false;
        }
        HitRefreshHandle this$handle = this.handle;
        HitRefreshHandle other$handle = other.handle;
        return !(this$handle == null ? other$handle != null : !this$handle.equals(other$handle));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runnable $exec = this.exec;
        result = result * 59 + ($exec == null ? 43 : $exec.hashCode());
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        HitRefreshHandle $handle = this.handle;
        result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
        return result;
    }

    private static final class HitRefreshHandle {
        private final File dir;
        private final List<File> flag;
        private final ReentrantReadWriteLock lock;

        HitRefreshHandle(File dir) {
            this(dir, new ReentrantReadWriteLock());
        }

        private HitRefreshHandle(File dir, ReentrantReadWriteLock lock) {
            this.dir = dir;
            this.lock = lock;
            this.flag = new CopyOnWriteArrayList<File>();
        }

        public File touchedFile() throws IOException {
            if (this.flag.isEmpty()) {
                this.lock.writeLock().lock();
                File file = File.createTempFile("take", ".txt");
                file.deleteOnExit();
                this.flag.add(file);
                this.lock.writeLock().unlock();
                this.touch();
            }
            return this.flag.get(0);
        }

        public void touch() throws IOException {
            try (OutputStream out = Files.newOutputStream(this.touchedFile().toPath(), new OpenOption[0]);){
                out.write(43);
            }
        }

        private boolean expired() throws IOException {
            boolean expired = this.flag.isEmpty() ? true : this.directoryUpdated();
            return expired;
        }

        private boolean directoryUpdated() {
            long recent;
            try {
                this.lock.readLock().lock();
                recent = this.flag.get(0).lastModified();
            }
            finally {
                this.lock.readLock().unlock();
            }
            File[] files = this.dir.listFiles();
            boolean expired = false;
            if (new Opt.Single<File[]>(files).has()) {
                for (File file : files) {
                    if (file.lastModified() <= recent) continue;
                    expired = true;
                    break;
                }
            }
            return expired;
        }
    }
}

