/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class FkParams
implements Fork {
    private final String name;
    private final Pattern pattern;
    private final Take take;

    public FkParams(String param, String ptn, Take tke) {
        this(param, Pattern.compile(ptn), tke);
    }

    public FkParams(String param, Pattern ptn, Take tke) {
        this.name = param;
        this.pattern = ptn;
        this.take = tke;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        Iterator<String> params = new RqHref.Base(req).href().param(this.name).iterator();
        Opt<Response> resp = params.hasNext() && this.pattern.matcher(params.next()).matches() ? new Opt.Single<Response>(this.take.act(req)) : new Opt.Empty<Response>();
        return resp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkParams)) {
            return false;
        }
        FkParams other = (FkParams)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Pattern this$pattern = this.pattern;
        Pattern other$pattern = other.pattern;
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Take this$take = this.take;
        Take other$take = other.take;
        return !(this$take == null ? other$take != null : !this$take.equals(other$take));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Pattern $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        return result;
    }
}

