/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.rq.RqFake;

public interface RqRegex
extends Request {
    public Matcher matcher();

    public static final class Fake
    implements RqRegex {
        private final Request request;
        private final Matcher mtr;

        public Fake(String ptn, CharSequence query) {
            this(new RqFake(), ptn, query);
        }

        public Fake(Request req, String ptn, CharSequence query) {
            this(req, Pattern.compile(ptn).matcher(query));
        }

        public Fake(Request req, Matcher matcher) {
            this.request = req;
            this.mtr = matcher;
        }

        @Override
        public Matcher matcher() {
            if (!this.mtr.matches()) {
                throw new IllegalArgumentException(String.format("%s doesn't match %s", this.request, this.mtr.pattern()));
            }
            return this.mtr;
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.request.head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.request.body();
        }
    }
}

