/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork.am;

import org.takes.facets.fork.am.AgentMatch;
import org.takes.facets.fork.am.VersionMatch;

public final class AmVersion
implements AgentMatch {
    private final String agent;
    private final VersionMatch version;

    public AmVersion(String agent, VersionMatch version) {
        this.agent = agent;
        this.version = version;
    }

    @Override
    public boolean matches(String token) {
        boolean result = true;
        String[] parts = token.split("/");
        if (parts.length <= 1) {
            result = false;
        } else if (!this.agent.equalsIgnoreCase(parts[0])) {
            result = false;
        } else if (!this.version.matches(AmVersion.majorVersion(parts[1]))) {
            result = false;
        }
        return result;
    }

    private static int majorVersion(String part) {
        return Integer.parseInt(part.split("\\.")[0]);
    }

    public static final class VmGreater
    implements VersionMatch {
        private final int ver;

        public VmGreater(int ver) {
            this.ver = ver;
        }

        @Override
        public boolean matches(int version) {
            return version > this.ver;
        }
    }
}

