/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.forward;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.takes.HttpException;
import org.takes.Response;
import org.takes.misc.Sprintf;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithoutHeader;

public class RsForward
extends HttpException
implements Response {
    private static final long serialVersionUID = 7676888610908953700L;
    private static final String HOME = "/";
    private final Response origin;

    public RsForward() {
        this(new RsEmpty());
    }

    public RsForward(Response res) {
        this(res, (CharSequence)HOME);
    }

    public RsForward(RsForward res) {
        this(res.origin);
    }

    public RsForward(Response res, CharSequence loc) {
        this(res, 303, loc);
    }

    public RsForward(RsForward res, CharSequence loc) {
        this(res.origin, loc);
    }

    public RsForward(CharSequence loc) {
        this(303, loc);
    }

    public RsForward(int code, CharSequence loc) {
        this(new RsEmpty(), code, loc);
    }

    public RsForward(Response res, int code) {
        this(res, code, (CharSequence)HOME);
    }

    public RsForward(RsForward res, int code, CharSequence loc) {
        this(res.origin, code, loc);
    }

    public RsForward(Response res, int code, CharSequence loc) {
        super(code, String.format("[%3d] %s %s", code, loc, res.toString()));
        this.origin = new RsWithHeader(new RsWithoutHeader(new RsWithStatus(res, code), "Location"), (CharSequence)new Sprintf("Location: %s", loc));
    }

    @Override
    public final Iterable<String> head() throws IOException {
        return this.origin.head();
    }

    @Override
    public final InputStream body() throws IOException {
        return this.origin.body();
    }

    private static void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private static void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public String toString() {
        return "RsForward(super=" + super.toString() + ", origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsForward)) {
            return false;
        }
        RsForward other = (RsForward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Response this$origin = this.origin;
        Response other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RsForward;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Response $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

