/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.hamcrest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public abstract class AbstractHmTextBody<T>
extends TypeSafeMatcher<T> {
    private final Matcher<String> body;
    private final Charset charset;

    public AbstractHmTextBody(Matcher<String> body, Charset charset) {
        this.body = body;
        this.charset = charset;
    }

    public final void describeTo(Description description) {
        description.appendText("body: ").appendDescriptionOf(this.body);
    }

    protected final boolean matchesSafely(T item) {
        try {
            return this.body.matches((Object)this.text(item));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected final void describeMismatchSafely(T item, Description description) {
        try {
            description.appendText("body was: ").appendText(this.text(item));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected abstract InputStream itemBody(T var1) throws IOException;

    private String text(T item) throws IOException {
        String text;
        try (InputStream input = this.itemBody(item);
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, len);
            }
            output.flush();
            text = new String(output.toByteArray(), this.charset);
        }
        return text;
    }
}

