/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.takes.http.Back;
import org.takes.http.BkWrap;

public final class BkParallel
extends BkWrap {
    public BkParallel(Back back) {
        this(back, Runtime.getRuntime().availableProcessors() << 2);
    }

    public BkParallel(Back back, int threads) {
        this(back, Executors.newFixedThreadPool(threads, new Threads()));
    }

    public BkParallel(final Back back, final ExecutorService svc) {
        super(new Back(){

            @Override
            public void accept(final Socket socket) {
                svc.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            back.accept(socket);
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                });
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BkParallel)) {
            return false;
        }
        BkParallel other = (BkParallel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BkParallel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class Threads
    implements ThreadFactory {
        private final AtomicInteger total = new AtomicInteger();

        private Threads() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName(String.format("%s-%d", BkParallel.class.getSimpleName(), this.total.getAndAdd(1)));
            return thread;
        }
    }
}

