/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

public interface Exit {
    public static final Exit NEVER = new Exit(){

        @Override
        public boolean ready() {
            return false;
        }
    };

    public boolean ready();

    public static final class Not
    implements Exit {
        private final Exit origin;

        public Not(Exit exit) {
            this.origin = exit;
        }

        @Override
        public boolean ready() {
            return !this.origin.ready();
        }
    }

    public static final class And
    implements Exit {
        private final Exit left;
        private final Exit right;

        public And(Exit lft, Exit rht) {
            this.left = lft;
            this.right = rht;
        }

        @Override
        public boolean ready() {
            return this.left.ready() && this.right.ready();
        }
    }

    public static final class Or
    implements Exit {
        private final Exit left;
        private final Exit right;

        public Or(Exit lft, Exit rht) {
            this.left = lft;
            this.right = rht;
        }

        @Override
        public boolean ready() {
            return this.left.ready() || this.right.ready();
        }
    }
}

