/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.takes.Take;
import org.takes.http.Back;
import org.takes.http.BkBasic;
import org.takes.http.BkSafe;
import org.takes.http.Exit;
import org.takes.http.Front;

public final class FtBasic
implements Front {
    private final Back back;
    private final ServerSocket socket;

    public FtBasic(Take tks) throws IOException {
        this((Back)new BkSafe(new BkBasic(tks)), 80);
    }

    public FtBasic(Take tks, int prt) throws IOException {
        this((Back)new BkSafe(new BkBasic(tks)), prt);
    }

    public FtBasic(Back bck, int port) throws IOException {
        this(bck, new ServerSocket(port));
    }

    public FtBasic(Back bck, ServerSocket skt) {
        this.back = bck;
        this.socket = skt;
    }

    @Override
    public void start(Exit exit) throws IOException {
        this.socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(1L));
        try {
            do {
                this.loop(this.socket);
            } while (!exit.ready());
        }
        finally {
            this.socket.close();
        }
    }

    private void loop(ServerSocket server) throws IOException {
        try {
            this.back.accept(server.accept());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FtBasic)) {
            return false;
        }
        FtBasic other = (FtBasic)o;
        Back this$back = this.back;
        Back other$back = other.back;
        if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
            return false;
        }
        ServerSocket this$socket = this.socket;
        ServerSocket other$socket = other.socket;
        return !(this$socket == null ? other$socket != null : !this$socket.equals(other$socket));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Back $back = this.back;
        result = result * 59 + ($back == null ? 43 : $back.hashCode());
        ServerSocket $socket = this.socket;
        result = result * 59 + ($socket == null ? 43 : $socket.hashCode());
        return result;
    }
}

