/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.cactoos.text.TrimmedText;
import org.takes.misc.Utf8String;

public final class MainRemote {
    private final Class<?> app;
    private final String[] args;

    public MainRemote(Class<?> type) {
        this(type, new String[0]);
    }

    public MainRemote(Class<?> type, String ... passed) {
        this.app = type;
        this.args = Arrays.copyOf(passed, passed.length);
    }

    public void exec(Script script) throws Exception {
        File file = File.createTempFile("takes-", ".txt");
        if (!file.delete()) {
            throw new IOException(String.format("The temporary file '%s' could not be deleted before calling the exec method", file.getAbsolutePath()));
        }
        Method method = this.app.getDeclaredMethod("main", String[].class);
        String[] passed = new String[1 + this.args.length];
        passed[0] = String.format("--port=%s", file.getAbsoluteFile());
        for (int idx = 0; idx < this.args.length; ++idx) {
            passed[idx + 1] = this.args[idx];
        }
        Thread thread = new Thread(new MainMethod(method, passed));
        thread.start();
        try {
            script.exec(URI.create(String.format("http://localhost:%d", MainRemote.port(file))));
        }
        catch (IOException ex) {
            if (!file.delete()) {
                ex.addSuppressed(new IOException(String.format("The temporary file '%s' could not be deleted while catching the error", file.getAbsolutePath())));
            }
            throw ex;
        }
        finally {
            thread.interrupt();
        }
        if (!file.delete()) {
            throw new IOException(String.format("The temporary file '%s' could not be deleted after calling the exec method", file.getAbsolutePath()));
        }
    }

    private static int port(File file) throws Exception {
        int port;
        while (!file.exists()) {
            TimeUnit.MILLISECONDS.sleep(1L);
        }
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] buf = new byte[10];
            while (input.read(buf) <= 0) {
            }
            port = Integer.parseInt(new TrimmedText(new Utf8String(buf)).asString());
        }
        return port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainRemote)) {
            return false;
        }
        MainRemote other = (MainRemote)o;
        Class<?> this$app = this.app;
        Class<?> other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        return Arrays.deepEquals(this.args, other.args);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.args);
        return result;
    }

    private static final class MainMethod
    implements Runnable {
        private final Method method;
        private final String[] passed;

        MainMethod(Method method, String ... passed) {
            this.method = method;
            this.passed = Arrays.copyOf(passed, passed.length);
        }

        @Override
        public void run() {
            try {
                this.method.invoke(null, new Object[]{this.passed});
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(String.format("The %s method has been invoked at an illegal time.", this.method.getName()), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(String.format("The visibility of the %s method do not allow access.", this.method.getName()), ex);
            }
        }
    }

    public static interface Script {
        public void exec(URI var1) throws IOException;
    }
}

