/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.misc.Utf8InputStreamContent;
import org.takes.misc.Utf8OutputStreamContent;

final class Options {
    private final Map<String, String> map;

    Options(String ... args) {
        this(Arrays.asList(args));
    }

    Options(Iterable<String> args) {
        this.map = Options.asMap(args);
    }

    public boolean isDaemon() {
        return this.map.containsKey("daemon");
    }

    public ServerSocket socket() throws IOException {
        ServerSocket socket;
        String port = this.map.get("port");
        if (port == null) {
            throw new IllegalArgumentException("--port must be specified");
        }
        if (port.matches("\\d+")) {
            socket = new ServerSocket(Integer.parseInt(port));
        } else {
            File file = new File(port);
            if (file.exists()) {
                try (Utf8InputStreamContent reader = new Utf8InputStreamContent(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                    char[] chars = new char[8];
                    int length = reader.read(chars);
                    socket = new ServerSocket(Integer.parseInt(new String(chars, 0, length)));
                }
            }
            socket = new ServerSocket(0);
            try (Utf8OutputStreamContent writer = new Utf8OutputStreamContent(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                ((Writer)writer).append(Integer.toString(socket.getLocalPort()));
            }
        }
        return socket;
    }

    public boolean hitRefresh() {
        return this.map.containsKey("hit-refresh");
    }

    public long lifetime() {
        return Long.parseLong(this.map.getOrDefault("lifetime", String.valueOf(Long.MAX_VALUE)));
    }

    public int threads() {
        return Integer.parseInt(this.map.getOrDefault("threads", String.valueOf(Runtime.getRuntime().availableProcessors() << 2)));
    }

    public long maxLatency() {
        return Long.parseLong(this.map.getOrDefault("max-latency", String.valueOf(Long.MAX_VALUE)));
    }

    private static Map<String, String> asMap(Iterable<String> args) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        Pattern ptn = Pattern.compile("--([a-z\\-]+)(=.+)?");
        for (String arg : args) {
            Matcher matcher = ptn.matcher(arg);
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("can't parse this argument: '%s'", arg));
            }
            String value = matcher.group(2);
            if (value == null) {
                map.put(matcher.group(1), "");
                continue;
            }
            map.put(matcher.group(1), value.substring(1));
        }
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Options)) {
            return false;
        }
        Options other = (Options)o;
        Map<String, String> this$map = this.map;
        Map<String, String> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }
}

