/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public interface Expires {
    public String print();

    public static final class Date
    implements Expires {
        private final ThreadLocal<SimpleDateFormat> format = ThreadLocal.withInitial(() -> new SimpleDateFormat(ptn, locale));
        private final java.util.Date expires;

        public Date(long expiration) {
            this("'Expires='EEE, dd MMM yyyy HH:mm:ss z", expiration);
        }

        public Date(String ptn, long expiration) {
            this(ptn, Locale.ENGLISH, expiration);
        }

        public Date(String ptn, Locale locale, long expiration) {
            this(ptn, locale, new java.util.Date(expiration));
        }

        public Date(String ptn, Locale locale, java.util.Date expires) {
            this.expires = new java.util.Date(expires.getTime());
        }

        @Override
        public String print() {
            SimpleDateFormat fmt = this.format.get();
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt.format(this.expires);
        }
    }

    public static final class Hour
    implements Expires {
        private final Expires origin;

        Hour(Expires origin) {
            this.origin = origin;
        }

        @Override
        public String print() {
            return this.origin.print();
        }
    }

    public static final class Expired
    implements Expires {
        @Override
        public String print() {
            return "Expires=0";
        }
    }

    public static final class Never
    implements Expires {
        private final Expires origin = new Date(0L);

        Never() {
        }

        @Override
        public String print() {
            return this.origin.print();
        }
    }
}

