/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.util.Iterator;
import org.takes.misc.TransformAction;

public final class Transform<T, K>
implements Iterable<K> {
    private final Iterable<T> list;
    private final TransformAction<T, K> action;

    public Transform(Iterable<T> itb, TransformAction<T, K> act) {
        this.list = itb;
        this.action = act;
    }

    public String toString() {
        return String.format("%s [via %s]", this.list, this.action);
    }

    @Override
    public Iterator<K> iterator() {
        return new TransformIterator<T, K>(this.list.iterator(), this.action);
    }

    private static class TransformIterator<B, A>
    implements Iterator<A> {
        private final Iterator<B> iterator;
        private final TransformAction<B, A> action;

        TransformIterator(Iterator<B> itr, TransformAction<B, A> act) {
            this.action = act;
            this.iterator = itr;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public A next() {
            return this.action.transform(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterable is immutable and cannot remove anything");
        }
    }
}

