/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;

final class CapInputStream
extends InputStream {
    private final InputStream origin;
    private long more;

    CapInputStream(InputStream stream, long length) {
        this.origin = stream;
        this.more = length;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, Math.max((long)this.origin.available(), this.more));
    }

    @Override
    public int read() throws IOException {
        int data;
        if (this.more <= 0L) {
            data = -1;
        } else {
            data = this.origin.read();
            --this.more;
        }
        return data;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int readed;
        if (this.more <= 0L) {
            readed = -1;
        } else {
            readed = this.origin.read(buf, off, Math.min(len, (int)this.more));
            this.more -= (long)readed;
        }
        return readed;
    }

    @Override
    public long skip(long num) throws IOException {
        return this.origin.skip(num);
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
    }
}

