/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.misc.EnglishLowerCase;
import org.takes.misc.VerboseList;
import org.takes.rq.RqWrap;

public interface RqHeaders
extends Request {
    public List<String> header(CharSequence var1) throws IOException;

    public Set<String> names() throws IOException;

    public static final class Smart
    implements RqHeaders {
        private final RqHeaders origin;

        public Smart(RqHeaders req) {
            this.origin = req;
        }

        public Smart(Request req) {
            this(new Base(req));
        }

        @Override
        public List<String> header(CharSequence name) throws IOException {
            return this.origin.header(name);
        }

        @Override
        public Set<String> names() throws IOException {
            return this.origin.names();
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.origin.head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.origin.body();
        }

        public String single(CharSequence name) throws IOException {
            Iterator<String> params = this.header(name).iterator();
            if (!params.hasNext()) {
                throw new HttpException(400, String.format("header \"%s\" is mandatory, not found among %s", name, this.names()));
            }
            return params.next();
        }

        public String single(CharSequence name, CharSequence def) throws IOException {
            Iterator<String> params = this.header(name).iterator();
            String value = params.hasNext() ? params.next() : def.toString();
            return value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            RqHeaders this$origin = this.origin;
            RqHeaders other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RqHeaders $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    public static final class Base
    extends RqWrap
    implements RqHeaders {
        public Base(Request req) {
            super(req);
        }

        @Override
        public List<String> header(CharSequence key) throws IOException {
            List values = this.map().getOrDefault(new EnglishLowerCase(key).string(), Collections.emptyList());
            VerboseList<String> list = values.isEmpty() ? new VerboseList(Collections.emptyList(), String.format("there are no headers by name \"%s\" among %d others: %s", key, this.map().size(), this.map().keySet())) : new VerboseList<String>(values, String.format("there are only %d headers by name \"%s\"", values.size(), key));
            return list;
        }

        @Override
        public Set<String> names() throws IOException {
            return this.map().keySet();
        }

        private Map<String, List<String>> map() throws IOException {
            Iterator<String> head = this.head().iterator();
            if (!head.hasNext()) {
                throw new HttpException(400, "a valid request must contain at least one line in the head");
            }
            head.next();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(0);
            while (head.hasNext()) {
                String line = head.next();
                String[] parts = line.split(":", 2);
                if (parts.length < 2) {
                    throw new HttpException(400, String.format("invalid HTTP header: \"%s\"", line));
                }
                String key = new EnglishLowerCase(parts[0].trim()).string();
                if (!map.containsKey(key)) {
                    map.put(key, new LinkedList());
                }
                ((List)map.get(key)).add(parts[1].trim());
            }
            return map;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }
}

