/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.takes.Request;
import org.takes.rq.CapInputStream;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqWrap;

public final class RqLengthAware
extends RqWrap {
    public RqLengthAware(final Request req) {
        super(new Request(){

            @Override
            public Iterable<String> head() throws IOException {
                return req.head();
            }

            @Override
            public InputStream body() throws IOException {
                return RqLengthAware.cap(req);
            }
        });
    }

    private static InputStream cap(Request req) throws IOException {
        Iterator<String> hdr = new RqHeaders.Base(req).header("Content-Length").iterator();
        InputStream body = req.body();
        long length = body.available();
        if (hdr.hasNext()) {
            length = Long.parseLong(hdr.next());
        }
        body = new CapInputStream(body, length);
        return body;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqLengthAware)) {
            return false;
        }
        RqLengthAware other = (RqLengthAware)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqLengthAware;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

