/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.misc.Opt;
import org.takes.misc.Utf8String;
import org.takes.rq.RqWrap;

public final class RqLive
extends RqWrap {
    public RqLive(InputStream input) throws IOException {
        super(RqLive.parse(input));
    }

    private static Request parse(final InputStream input) throws IOException {
        boolean eof = true;
        final LinkedList<String> head = new LinkedList<String>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Opt<Integer> data = new Opt.Empty<Integer>();
        data = RqLive.data(input, data, false);
        while (data.get() > 0) {
            eof = false;
            if (data.get() == 13) {
                RqLive.checkLineFeed(input, baos, head.size() + 1);
                if (baos.size() == 0) break;
                data = new Opt.Single<Integer>(input.read());
                Opt<String> header = RqLive.newHeader(data, baos);
                if (header.has()) {
                    head.add(header.get());
                }
                data = RqLive.data(input, data, false);
                continue;
            }
            baos.write(RqLive.legalCharacter(data, baos, head.size() + 1));
            data = RqLive.data(input, new Opt.Empty<Integer>(), true);
        }
        if (eof) {
            throw new IOException("empty request");
        }
        return new Request(){

            @Override
            public Iterable<String> head() {
                return head;
            }

            @Override
            public InputStream body() {
                return input;
            }
        };
    }

    private static void checkLineFeed(InputStream input, ByteArrayOutputStream baos, Integer position) throws IOException {
        if (input.read() != 10) {
            throw new HttpException(400, String.format("there is no LF after CR in header, line #%d: \"%s\"", position, new Utf8String(baos.toByteArray()).asString()));
        }
    }

    private static Opt<String> newHeader(Opt<Integer> data, ByteArrayOutputStream baos) {
        Opt<String> header = new Opt.Empty<String>();
        if (data.get() != 32 && data.get() != 9) {
            header = new Opt.Single<String>(new Utf8String(baos.toByteArray()).asString());
            baos.reset();
        }
        return header;
    }

    private static Integer legalCharacter(Opt<Integer> data, ByteArrayOutputStream baos, Integer position) throws HttpException {
        if ((data.get() > 127 || data.get() < 32) && data.get() != 9) {
            throw new HttpException(400, String.format("illegal character 0x%02X in HTTP header line #%d: \"%s\"", data.get(), position, new Utf8String(baos.toByteArray()).asString()));
        }
        return data.get();
    }

    private static Opt<Integer> data(InputStream input, Opt<Integer> data, boolean available) throws IOException {
        Opt<Integer> ret = data.has() ? data : (available && input.available() <= 0 ? new Opt.Single<Integer>(-1) : new Opt.Single<Integer>(input.read()));
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqLive)) {
            return false;
        }
        RqLive other = (RqLive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqLive;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

