/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.rq.RqRequestLine;
import org.takes.rq.RqWrap;

public interface RqMethod
extends Request {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String PATCH = "PATCH";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";

    public String method() throws IOException;

    public static final class Base
    extends RqWrap
    implements RqMethod {
        private static final Pattern SEPARATORS = Pattern.compile("[()<>@,;:\\\"/\\[\\]?={}]");

        public Base(Request req) {
            super(req);
        }

        @Override
        public String method() throws IOException {
            String method = new RqRequestLine.Base(this).method();
            if (SEPARATORS.matcher(method).find()) {
                throw new IOException(String.format("Invalid HTTP method: %s", method));
            }
            return method.toUpperCase(Locale.ENGLISH);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }
}

