/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class TempInputStream
extends InputStream {
    private final InputStream origin;
    private final File file;

    public TempInputStream(InputStream stream, File temp) {
        this.origin = stream;
        this.file = temp;
    }

    @Override
    public void close() throws IOException {
        try {
            this.origin.close();
        }
        finally {
            Path path = Paths.get(this.file.getAbsolutePath(), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.origin.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.origin.read(buf);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.origin.read(buf, off, len);
    }

    @Override
    public long skip(long num) throws IOException {
        return this.origin.skip(num);
    }

    @Override
    public int available() throws IOException {
        return this.origin.available();
    }
}

