/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq.multipart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.takes.Request;
import org.takes.misc.Utf8String;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqMultipart;
import org.takes.rq.RqPrint;
import org.takes.rq.RqWithHeaders;
import org.takes.rq.multipart.RqMtBase;

public final class RqMtFake
implements RqMultipart {
    private static final String BOUNDARY = "AaB02x";
    private static final String CRLF = "\r\n";
    private final RqMultipart fake;

    public RqMtFake(Request req, Request ... dispositions) throws IOException {
        this.fake = new RqMtBase(new FakeMultipartRequest(req, dispositions));
    }

    @Override
    public Iterable<Request> part(CharSequence name) {
        return this.fake.part(name);
    }

    @Override
    public Iterable<String> names() {
        return this.fake.names();
    }

    @Override
    public Iterable<String> head() throws IOException {
        return this.fake.head();
    }

    @Override
    public InputStream body() throws IOException {
        return this.fake.body();
    }

    private static StringBuilder fakeBody(Request ... parts) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Request part : parts) {
            builder.append(String.format("--%s", BOUNDARY)).append(CRLF).append("Content-Disposition: ").append(new RqHeaders.Smart(new RqHeaders.Base(part)).single("Content-Disposition")).append(CRLF);
            String body = new RqPrint(part).printBody();
            if (CRLF.equals(body) || body.isEmpty()) continue;
            builder.append(CRLF).append(body).append(CRLF);
        }
        builder.append("Content-Transfer-Encoding: utf-8").append(CRLF).append(String.format("--%s--", BOUNDARY));
        return builder;
    }

    private static final class FakeMultipartRequest
    implements Request {
        private final Request req;
        private final String parts;

        FakeMultipartRequest(Request rqst, Request ... list) throws IOException {
            this.req = rqst;
            this.parts = RqMtFake.fakeBody(list).toString();
        }

        @Override
        public Iterable<String> head() throws IOException {
            return new RqWithHeaders(this.req, String.format("Content-Type: multipart/form-data; boundary=%s", RqMtFake.BOUNDARY), String.format("Content-Length: %s", this.parts.length())).head();
        }

        @Override
        public InputStream body() {
            return new ByteArrayInputStream(new Utf8String(this.parts).asBytes());
        }
    }
}

