/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.regex.Pattern;
import org.takes.Response;
import org.takes.misc.Concat;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWrap;

public final class RsWithHeader
extends RsWrap {
    private static final Pattern HEADER = Pattern.compile("[a-zA-Z0-9\\-]+:\\p{Print}+");

    public RsWithHeader(CharSequence hdr) {
        this(new RsEmpty(), hdr);
    }

    public RsWithHeader(CharSequence name, CharSequence value) {
        this(new RsEmpty(), name, value);
    }

    public RsWithHeader(Response res, CharSequence name, CharSequence value) {
        this(res, (CharSequence)String.format("%s: %s", name, value));
    }

    public RsWithHeader(final Response res, final CharSequence header) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return RsWithHeader.extend(res.head(), header.toString());
            }

            @Override
            public InputStream body() throws IOException {
                return res.body();
            }
        });
    }

    private static Iterable<String> extend(Iterable<String> head, String header) {
        if (!HEADER.matcher(header).matches()) {
            throw new IllegalArgumentException(String.format("header line of HTTP response \"%s\" doesn't match \"%s\" regular expression, but it should, according to RFC 7230", header, HEADER));
        }
        return new Concat<String>(head, Collections.singleton(header));
    }

    @Override
    public String toString() {
        return "RsWithHeader(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithHeader)) {
            return false;
        }
        RsWithHeader other = (RsWithHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithHeader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

