/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.takes.Response;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWrap;

public final class RsWithHeaders
extends RsWrap {
    public RsWithHeaders(Iterable<? extends CharSequence> headers) {
        this((Response)new RsEmpty(), headers);
    }

    public RsWithHeaders(Response res, CharSequence ... headers) {
        this(res, Arrays.asList(headers));
    }

    public RsWithHeaders(final Response res, final Iterable<? extends CharSequence> headers) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return RsWithHeaders.extend(res, headers);
            }

            @Override
            public InputStream body() throws IOException {
                return res.body();
            }
        });
    }

    private static Iterable<String> extend(Response res, Iterable<? extends CharSequence> headers) throws IOException {
        Response resp = res;
        for (CharSequence charSequence : headers) {
            resp = new RsWithHeader(resp, charSequence);
        }
        return resp.head();
    }

    @Override
    public String toString() {
        return "RsWithHeaders(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithHeaders)) {
            return false;
        }
        RsWithHeaders other = (RsWithHeaders)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithHeaders;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

