/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cactoos.iterable.Filtered;
import org.takes.Response;
import org.takes.misc.Concat;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWrap;

public final class RsWithStatus
extends RsWrap {
    private static final Map<Integer, String> REASONS = Collections.unmodifiableMap(RsWithStatus.make());

    public RsWithStatus(int code) {
        this(new RsEmpty(), code);
    }

    public RsWithStatus(Response res, int code) {
        this(res, code, RsWithStatus.best(code));
    }

    public RsWithStatus(final Response res, final int code, final CharSequence rsn) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return RsWithStatus.head(res, code, rsn);
            }

            @Override
            public InputStream body() throws IOException {
                return res.body();
            }
        });
    }

    private static Iterable<String> head(Response origin, int status, CharSequence reason) throws IOException {
        if (status < 100 || status > 999) {
            throw new IllegalArgumentException(String.format("according to RFC 7230 HTTP status code must have three digits: %d", status));
        }
        return new Concat<String>(Collections.singletonList(String.format("HTTP/1.1 %d %s", status, reason)), new Filtered<String>(item -> !item.startsWith("HTTP/"), origin.head()));
    }

    private static String best(int code) {
        return REASONS.getOrDefault(code, "Unknown");
    }

    private static Map<Integer, String> make() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(0);
        map.put(200, "OK");
        map.put(204, "No Content");
        map.put(201, "Created");
        map.put(202, "Accepted");
        map.put(301, "Moved Permanently");
        map.put(302, "Moved Temporarily");
        map.put(303, "See Other");
        map.put(304, "Not Modified");
        map.put(305, "Use Proxy");
        map.put(400, "Bad Request");
        map.put(401, "Unauthorized");
        map.put(402, "Payment Required");
        map.put(403, "Forbidden");
        map.put(404, "Not Found");
        map.put(405, "Bad Method");
        map.put(406, "Not Acceptable");
        map.put(408, "Client Timeout");
        map.put(410, "Gone");
        map.put(411, "Length Required");
        map.put(412, "Precon Failed");
        map.put(413, "Entity Too Large");
        map.put(414, "Request Too Long");
        map.put(415, "Unsupported Type");
        map.put(500, "Internal Error");
        map.put(502, "Bad Gateway");
        map.put(501, "Not Implemented");
        return map;
    }

    @Override
    public String toString() {
        return "RsWithStatus(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithStatus)) {
            return false;
        }
        RsWithStatus other = (RsWithStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

