/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.nio.charset.Charset;
import org.takes.Response;
import org.takes.misc.Opt;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWithoutHeader;
import org.takes.rs.RsWrap;

public final class RsWithType
extends RsWrap {
    private static final String HEADER = "Content-Type";
    private static final String CHARSET = "charset";

    public RsWithType(Response res, CharSequence type) {
        this(res, type, new Opt.Empty<Charset>());
    }

    public RsWithType(Response res, CharSequence type, Charset charset) {
        this(res, type, new Opt.Single<Charset>(charset));
    }

    private RsWithType(Response res, CharSequence type, Opt<Charset> charset) {
        super(RsWithType.make(res, type, charset));
    }

    private static Response make(Response res, CharSequence type, Opt<Charset> charset) {
        RsWithHeader response = charset.has() ? new RsWithHeader(new RsWithoutHeader(res, HEADER), HEADER, String.format("%s; %s=%s", type, CHARSET, charset.get().name())) : new RsWithHeader(new RsWithoutHeader(res, HEADER), HEADER, type);
        return response;
    }

    @Override
    public String toString() {
        return "RsWithType(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithType)) {
            return false;
        }
        RsWithType other = (RsWithType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static final class Text
    extends RsWrap {
        public Text(Response res) {
            this(res, new Opt.Empty<Charset>());
        }

        public Text(Response res, Charset charset) {
            this(res, new Opt.Single<Charset>(charset));
        }

        private Text(Response res, Opt<Charset> charset) {
            super(RsWithType.make(res, "text/plain", charset));
        }
    }

    public static final class Xml
    extends RsWrap {
        public Xml(Response res) {
            this(res, new Opt.Empty<Charset>());
        }

        public Xml(Response res, Charset charset) {
            this(res, new Opt.Single<Charset>(charset));
        }

        private Xml(Response res, Opt<Charset> charset) {
            super(RsWithType.make(res, "text/xml", charset));
        }
    }

    public static final class Json
    extends RsWrap {
        public Json(Response res) {
            this(res, new Opt.Empty<Charset>());
        }

        public Json(Response res, Charset charset) {
            this(res, new Opt.Single<Charset>(charset));
        }

        private Json(Response res, Opt<Charset> charset) {
            super(RsWithType.make(res, "application/json", charset));
        }
    }

    public static final class Html
    extends RsWrap {
        public Html(Response res) {
            this(res, new Opt.Empty<Charset>());
        }

        public Html(Response res, Charset charset) {
            this(res, new Opt.Single<Charset>(charset));
        }

        private Html(Response res, Opt<Charset> charset) {
            super(RsWithType.make(res, "text/html", charset));
        }
    }
}

