/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.takes.Response;
import org.takes.misc.Utf8InputStreamContent;
import org.takes.misc.Utf8OutputStreamContent;
import org.takes.misc.Utf8String;
import org.takes.rs.RsWrap;

public final class RsXslt
extends RsWrap {
    public RsXslt(Response rsp) {
        this(rsp, new InClasspath());
    }

    public RsXslt(final Response rsp, final URIResolver resolver) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return rsp.head();
            }

            @Override
            public InputStream body() throws IOException {
                return RsXslt.transform(rsp.body(), resolver);
            }
        });
    }

    private static InputStream transform(InputStream origin, URIResolver resolver) throws IOException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(resolver);
            return RsXslt.transform(factory, origin);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    private static InputStream transform(TransformerFactory factory, InputStream xml) throws TransformerException {
        byte[] input;
        try {
            input = RsXslt.consume(xml);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Source xsl = RsXslt.stylesheet(factory, new StreamSource(new Utf8InputStreamContent(new ByteArrayInputStream(new Utf8String(input).asBytes()))));
        RsXslt.transformer(factory, xsl).transform(new StreamSource(new Utf8InputStreamContent(new ByteArrayInputStream(new Utf8String(input).asBytes()))), new StreamResult(new Utf8OutputStreamContent(baos)));
        return new ByteArrayInputStream(new Utf8String(baos.toByteArray()).asBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] consume(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int bytes;
            while ((bytes = input.read(buf)) >= 0) {
                baos.write(buf, 0, bytes);
            }
        }
        finally {
            input.close();
        }
        return baos.toByteArray();
    }

    private static Source stylesheet(TransformerFactory factory, Source xml) throws TransformerConfigurationException {
        Source stylesheet = factory.getAssociatedStylesheet(xml, null, null, null);
        if (stylesheet == null) {
            throw new IllegalArgumentException("no associated stylesheet found in XML");
        }
        return stylesheet;
    }

    private static Transformer transformer(TransformerFactory factory, Source stylesheet) throws TransformerConfigurationException {
        Transformer tnfr = factory.newTransformer(stylesheet);
        if (tnfr == null) {
            throw new TransformerConfigurationException(String.format("%s failed to create new XSL transformer for '%s'", factory.getClass(), stylesheet.getSystemId()));
        }
        return tnfr;
    }

    @Override
    public String toString() {
        return "RsXslt(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsXslt)) {
            return false;
        }
        RsXslt other = (RsXslt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsXslt;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class InClasspath
    implements URIResolver {
        private InClasspath() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            InputStream input;
            URI uri = base == null || base.isEmpty() ? URI.create(href) : URI.create(base).resolve(href);
            if (uri.isAbsolute()) {
                try {
                    input = uri.toURL().openStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            } else {
                input = this.getClass().getResourceAsStream(uri.getPath());
                if (input == null) {
                    throw new TransformerException(String.format("\"%s\" not found in classpath, base=\"%s\"", href, base));
                }
            }
            return new StreamSource(new Utf8InputStreamContent(input));
        }
    }
}

