/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs.xe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.takes.Response;
import org.takes.misc.Utf8OutputStreamContent;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithType;
import org.takes.rs.RsWrap;
import org.takes.rs.xe.XeChain;
import org.takes.rs.xe.XeSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xembly.Xembler;

public final class RsXembly
extends RsWrap {
    public RsXembly(XeSource ... sources) {
        this(Arrays.asList(sources));
    }

    public RsXembly(Node dom, XeSource ... sources) {
        this(dom, Arrays.asList(sources));
    }

    public RsXembly(Iterable<XeSource> sources) {
        this((XeSource)new XeChain(sources));
    }

    public RsXembly(Node dom, Iterable<XeSource> sources) {
        this(dom, (XeSource)new XeChain(sources));
    }

    public RsXembly(XeSource src) {
        this((Node)RsXembly.emptyDocument(), src);
    }

    public RsXembly(final Node dom, final XeSource src) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return new RsWithType(new RsWithStatus(new RsEmpty(), 200), "text/xml").head();
            }

            @Override
            public InputStream body() throws IOException {
                return RsXembly.render(dom, src);
            }
        });
    }

    private static InputStream render(Node dom, XeSource src) throws IOException {
        Node copy = RsXembly.cloneNode(dom);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Node node = new Xembler(src.toXembly()).applyQuietly(copy);
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(node), new StreamResult(new Utf8OutputStreamContent(baos)));
        }
        catch (TransformerException ex) {
            throw new IllegalStateException(ex);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static Document emptyDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Could not instantiate DocumentBuilderFactory and build empty Document", ex);
        }
    }

    private static Node cloneNode(Node dom) {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new IllegalStateException("Could not create new Transformer to clone Node", ex);
        }
        DOMSource source = new DOMSource(dom);
        try {
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            return result.getNode();
        }
        catch (TransformerException ex) {
            throw new IllegalArgumentException(String.format("Could not clone Node %s with Transformer %s", source, transformer), ex);
        }
    }

    @Override
    public String toString() {
        return "RsXembly(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsXembly)) {
            return false;
        }
        RsXembly other = (RsXembly)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsXembly;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

