/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs.xe;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.takes.Scalar;
import org.takes.rs.xe.XeSource;
import org.xembly.Directive;
import org.xembly.Directives;
import org.xembly.SyntaxException;

public final class XeDirectives
implements XeSource {
    private final Scalar<Iterable<Directive>> directives;

    public XeDirectives(String ... dirs) {
        this(XeDirectives.transform(Arrays.asList(dirs)));
    }

    public XeDirectives(Directive ... dirs) {
        this(Arrays.asList(dirs));
    }

    public XeDirectives(final Iterable<Directive> dirs) {
        this(new Scalar<Iterable<Directive>>(){

            @Override
            public Iterable<Directive> get() {
                return dirs;
            }
        });
    }

    public XeDirectives(Scalar<Iterable<Directive>> dirs) {
        this.directives = dirs;
    }

    @Override
    public Iterable<Directive> toXembly() throws IOException {
        return this.directives.get();
    }

    private static Iterable<Directive> transform(Iterable<String> texts) {
        LinkedList<Directive> list = new LinkedList<Directive>();
        for (String text : texts) {
            try {
                for (Directive dir : new Directives(text)) {
                    list.add(dir);
                }
            }
            catch (SyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XeDirectives)) {
            return false;
        }
        XeDirectives other = (XeDirectives)o;
        Scalar<Iterable<Directive>> this$directives = this.directives;
        Scalar<Iterable<Directive>> other$directives = other.directives;
        return !(this$directives == null ? other$directives != null : !this$directives.equals(other$directives));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Scalar<Iterable<Directive>> $directives = this.directives;
        result = result * 59 + ($directives == null ? 43 : $directives.hashCode());
        return result;
    }
}

