/*
 * Decompiled with CFR 0.152.
 */
package org.takes.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.takes.Request;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqHref;
import org.takes.rq.RqMethod;
import org.takes.servlet.ServletInputStreamOf;

public final class HttpServletRequestFake
implements HttpServletRequest {
    private final Request request;

    public HttpServletRequestFake(Request req) {
        this.request = req;
    }

    public String getHeader(String key) {
        Enumeration<String> headers = this.getHeaders(key);
        if (!headers.hasMoreElements()) {
            throw new NoSuchElementException(String.format("Value of header %s not found", key));
        }
        return headers.nextElement();
    }

    public Enumeration<String> getHeaders(String key) {
        try {
            return Collections.enumeration(new RqHeaders.Base(this.request).header(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Enumeration<String> getHeaderNames() {
        try {
            return Collections.enumeration(new RqHeaders.Base(this.request).names());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getMethod() {
        try {
            return new RqMethod.Base(this.request).method();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamOf(this.request.body());
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getLocalName() {
        return "localhost";
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return new SecureRandom().nextInt();
    }

    public String getRequestURI() {
        try {
            return new RqHref.Base(this.request).href().path();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getQueryString() {
        try {
            return new URI(this.getRequestURI()).getQuery();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getServerName() {
        try {
            String host = new URI(this.getRequestURI()).getHost();
            if (host == null || host.isEmpty()) {
                host = "localhost";
            }
            return host;
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int getServerPort() {
        try {
            int port = new URI(this.getRequestURI()).getPort();
            if (port == -1) {
                port = 80;
            }
            return port;
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getAuthType() {
        throw new UnsupportedOperationException("#getAuthType()");
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException("#getCookies()");
    }

    public long getDateHeader(String key) {
        throw new UnsupportedOperationException("#getDateHeader()");
    }

    public int getIntHeader(String key) {
        throw new UnsupportedOperationException("#getIntHeader()");
    }

    public String getPathInfo() {
        throw new UnsupportedOperationException("#getPathInfo()");
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("#getPathTranslated()");
    }

    public String getContextPath() {
        throw new UnsupportedOperationException("#getContextPath()");
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("#getRemoteUser()");
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("#isUserInRole()");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("#getUserPrincipal");
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("#getRequestedSessionId");
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException("#getRequestURL()");
    }

    public String getServletPath() {
        throw new UnsupportedOperationException("#getServletPath()");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("#getSession()");
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("#getSession");
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("#changeSessionId()");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("#isRequestedSessionIdValid()");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("#isRequestedSessionIdFromCookie()");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("#isRequestedSessionIdFromURL()");
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("#isRequestedSessionIdFromUrl()");
    }

    public boolean authenticate(HttpServletResponse resp) throws IOException, ServletException {
        throw new UnsupportedOperationException("#authenticate()");
    }

    public void login(String user, String password) throws ServletException {
        throw new UnsupportedOperationException("#login()");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("#logout()");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("#getParts()");
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new UnsupportedOperationException("#getPart()");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> cls) throws IOException, ServletException {
        throw new UnsupportedOperationException("#upgrade()");
    }

    public Object getAttribute(String name) {
        throw new UnsupportedOperationException("#getAttribute()");
    }

    public Enumeration<String> getAttributeNames() {
        throw new UnsupportedOperationException("#getAttributeNames()");
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException("#getCharacterEncoding()");
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("#setCharacterEncoding()");
    }

    public int getContentLength() {
        throw new UnsupportedOperationException("#getContentLength()");
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException("#getContentLengthLong()");
    }

    public String getContentType() {
        throw new UnsupportedOperationException("#getContentType()");
    }

    public String getParameter(String key) {
        throw new UnsupportedOperationException("#getParameter()");
    }

    public Enumeration<String> getParameterNames() {
        throw new UnsupportedOperationException("#getParameterNames()");
    }

    public String[] getParameterValues(String key) {
        throw new UnsupportedOperationException("#getParameterValues()");
    }

    public Map<String, String[]> getParameterMap() {
        throw new UnsupportedOperationException("#getParameterMap()");
    }

    public String getProtocol() {
        throw new UnsupportedOperationException("#getProtocol()");
    }

    public String getScheme() {
        throw new UnsupportedOperationException("#getScheme()");
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("#getReader()");
    }

    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException("#setAttribute");
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException("#removeAttribute");
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException("#getLocale()");
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException("#getLocales()");
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException("#isSecure()");
    }

    public RequestDispatcher getRequestDispatcher(String dispatcher) {
        throw new UnsupportedOperationException("#getRequestDispatcher()");
    }

    @Deprecated
    public String getRealPath(String path) {
        throw new UnsupportedOperationException("#getRealPath()");
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException("#getRemotePort()");
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("#getServletContext()");
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("#startAsync()");
    }

    public AsyncContext startAsync(ServletRequest req, ServletResponse resp) throws IllegalStateException {
        throw new UnsupportedOperationException("#startAsync(req, resp)");
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException("#isAsyncStarted()");
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException("#isAsyncSupported()");
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("#getAsyncContext()");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("#getDispatcherType()");
    }
}

