/*
 * Decompiled with CFR 0.152.
 */
package org.takes.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.cactoos.Input;
import org.cactoos.Output;
import org.cactoos.io.InputOf;
import org.cactoos.io.LengthOf;
import org.cactoos.io.OutputTo;
import org.cactoos.io.TeeInput;
import org.cactoos.iterable.Filtered;
import org.cactoos.list.ListOf;
import org.takes.Response;
import org.takes.facets.cookies.RsWithCookie;
import org.takes.misc.EnglishLowerCase;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithoutHeader;
import org.takes.servlet.ServletOutputStreamTo;

public final class HttpServletResponseFake
implements HttpServletResponse {
    private final AtomicReference<Response> response;

    public HttpServletResponseFake(Response resp) {
        this.response = new AtomicReference<Response>(resp);
    }

    public void addCookie(Cookie cookie) {
        this.response.set(new RsWithCookie(this.response.get(), (CharSequence)cookie.getName(), (CharSequence)cookie.getValue(), new CharSequence[0]));
    }

    public void setHeader(String name, String value) {
        this.response.set(new RsWithHeader(new RsWithoutHeader(this.response.get(), name), name, value));
    }

    public void setStatus(int code) {
        this.response.set(new RsWithStatus(this.response.get(), code));
    }

    public void sendError(int code, String reason) throws IOException {
        this.response.set(new RsWithStatus(this.response.get(), code, reason));
    }

    public Collection<String> getHeaders(String header) {
        String prefix = String.format("%s:", new EnglishLowerCase(header));
        try {
            return new ListOf<String>((Iterable<String>)new Filtered<String>(hdr -> !new EnglishLowerCase((String)hdr).string().startsWith(prefix), this.response.get().head()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new LengthOf(new TeeInput((Input)new InputOf(this.response.get().body()), (Output)new OutputTo(baos))).intValue();
        return new ServletOutputStreamTo(baos);
    }

    public String getHeader(String header) {
        throw new UnsupportedOperationException("#getHeaders()");
    }

    public boolean containsHeader(String header) {
        throw new UnsupportedOperationException("#containsHeader()");
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException("#encodeURL()");
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException("#encodeRedirectURL()");
    }

    @Deprecated
    public String encodeUrl(String url) {
        throw new UnsupportedOperationException("#encodeUrl()");
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException("#encodeRedirectUrl()");
    }

    public void sendError(int code) throws IOException {
        throw new UnsupportedOperationException("#sendError()");
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException("#sendRedirect()");
    }

    public void setDateHeader(String name, long time) {
        throw new UnsupportedOperationException("#setDateHeader()");
    }

    public void addDateHeader(String name, long date) {
        throw new UnsupportedOperationException("#addDateHeader()");
    }

    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException("#addHeader()");
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException("#setIntHeader()");
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException("#addIntHeader()");
    }

    @Deprecated
    public void setStatus(int code, String reason) {
        throw new UnsupportedOperationException("#setStatus()");
    }

    public int getStatus() {
        throw new UnsupportedOperationException("#getStatus()");
    }

    public Collection<String> getHeaderNames() {
        throw new UnsupportedOperationException("#getHeaderNames()");
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException("#getCharacterEncoding()");
    }

    public String getContentType() {
        throw new UnsupportedOperationException("#getContentType()");
    }

    public PrintWriter getWriter() throws IOException {
        throw new UnsupportedOperationException("#getWriter()");
    }

    public void setCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException("#setCharacterEncoding()");
    }

    public void setContentLength(int length) {
        throw new UnsupportedOperationException("#setContentLength()");
    }

    public void setContentLengthLong(long length) {
        throw new UnsupportedOperationException("#setContentLengthLong()");
    }

    public void setContentType(String type) {
        throw new UnsupportedOperationException("#setContentType()");
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException("#setBufferSize()");
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException("#getBufferSize()");
    }

    public void flushBuffer() throws IOException {
        throw new UnsupportedOperationException("#flushBuffer()");
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException("#resetBuffer()");
    }

    public boolean isCommitted() {
        throw new UnsupportedOperationException("#isCommited()");
    }

    public void reset() {
        throw new UnsupportedOperationException("#reset()");
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException("#setLocale()");
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException("#getLocale()");
    }
}

