/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHeaders;
import org.takes.rs.RsWithHeaders;
import org.takes.rs.RsWithStatus;

public final class TkCors
implements Take {
    private final Take origin;
    private final Set<String> allowed;

    public TkCors(Take take, String ... domains) {
        this.origin = take;
        this.allowed = new HashSet<String>(Arrays.asList(domains));
    }

    @Override
    public Response act(Request req) throws Exception {
        String domain = new RqHeaders.Smart(new RqHeaders.Base(req)).single("origin", "");
        RsWithHeaders response = this.allowed.contains(domain) ? new RsWithHeaders(this.origin.act(req), "Access-Control-Allow-Credentials: true", "Access-Control-Allow-Methods: OPTIONS, GET, PUT, POST, DELETE, HEAD", String.format("Access-Control-Allow-Origin: %s", domain)) : new RsWithHeaders((Response)new RsWithStatus(403), "Access-Control-Allow-Credentials: false");
        return response;
    }

    public String toString() {
        return "TkCors(origin=" + this.origin + ", allowed=" + this.allowed + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkCors)) {
            return false;
        }
        TkCors other = (TkCors)o;
        Take this$origin = this.origin;
        Take other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Set<String> this$allowed = this.allowed;
        Set<String> other$allowed = other.allowed;
        return !(this$allowed == null ? other$allowed != null : !((Object)this$allowed).equals(other$allowed));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Set<String> $allowed = this.allowed;
        result = result * 59 + ($allowed == null ? 43 : ((Object)$allowed).hashCode());
        return result;
    }
}

