/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.misc.Opt;
import org.takes.misc.Transform;
import org.takes.misc.TransformAction;

public final class TkRetry
implements Take {
    private final int count;
    private final int delay;
    private final Take take;

    public TkRetry(int retries, int wait, Take original) {
        this.count = retries;
        this.delay = wait;
        this.take = original;
    }

    @Override
    public Response act(Request req) throws IOException {
        if (this.count <= 0) {
            throw new IllegalArgumentException("can't make less than one attempt");
        }
        ArrayList<Exception> failures = new ArrayList<Exception>(this.count);
        for (int attempts = 0; attempts < this.count; ++attempts) {
            try {
                return this.take.act(req);
            }
            catch (Exception ex) {
                failures.add(ex);
                this.sleep();
                continue;
            }
        }
        throw new IOException(String.format("failed after %d attempts: %s", failures.size(), TkRetry.strings(failures)), (Throwable)failures.get(failures.size() - 1));
    }

    private static List<String> strings(List<Exception> failures) {
        ArrayList<String> result = new ArrayList<String>(failures.size());
        Transform<Exception, String> transform = new Transform<Exception, String>(failures, new TransformAction<Exception, String>(){

            @Override
            public String transform(Exception element) {
                Opt.Single<String> message = new Opt.Single<String>(element.getMessage());
                String result = "";
                if (message.has()) {
                    result = (String)message.get();
                }
                return result;
            }
        });
        Iterator messages = transform.iterator();
        while (messages.hasNext()) {
            result.add((String)messages.next());
        }
        return result;
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.delay);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unexpected interruption while retrying to process request", ex);
        }
    }
}

