/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHref;
import org.takes.rq.RqMethod;

public final class TkSlf4j
implements Take {
    private final Take origin;
    private final String target;

    public TkSlf4j(Take take) {
        this(take, TkSlf4j.class);
    }

    public TkSlf4j(Take take, Class<?> tgt) {
        this(take, tgt.getCanonicalName());
    }

    public TkSlf4j(Take take, String tgt) {
        this.target = tgt;
        this.origin = take;
    }

    @Override
    public Response act(Request req) throws Exception {
        long start = System.currentTimeMillis();
        Logger logger = LoggerFactory.getLogger(this.target);
        try {
            Response rsp = this.origin.act(req);
            if (logger.isInfoEnabled()) {
                logger.info("[{} {}] returned \"{}\" in {} ms", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), rsp.head().iterator().next(), System.currentTimeMillis() - start);
            }
            return rsp;
        }
        catch (IOException ex) {
            if (logger.isInfoEnabled()) {
                logger.info("[{} {}] thrown {}(\"{}\") in {} ms", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), ex.getClass().getCanonicalName(), ex.getLocalizedMessage(), System.currentTimeMillis() - start);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (logger.isInfoEnabled()) {
                logger.info("[{} {}] thrown runtime {}(\"{}\") in {} ms", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), ex.getClass().getCanonicalName(), ex.getLocalizedMessage(), System.currentTimeMillis() - start);
            }
            throw ex;
        }
    }

    public String toString() {
        return "TkSlf4j(origin=" + this.origin + ", target=" + this.target + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkSlf4j)) {
            return false;
        }
        TkSlf4j other = (TkSlf4j)o;
        Take this$origin = this.origin;
        Take other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$target = this.target;
        String other$target = other.target;
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $target = this.target;
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }
}

