/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing;

import com.github.containersolutions.operator.api.ResourceController;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private final ResourceController controller;
    private final String resourceDefaultFinalizer;
    private final CustomResourceReplaceFacade customResourceReplaceFacade;

    public EventDispatcher(ResourceController controller, String defaultFinalizer, CustomResourceReplaceFacade customResourceReplaceFacade) {
        this.controller = controller;
        this.customResourceReplaceFacade = customResourceReplaceFacade;
        this.resourceDefaultFinalizer = defaultFinalizer;
    }

    public void handleEvent(Watcher.Action action, CustomResource resource) {
        log.info("Handling event {} for resource {}", (Object)action, (Object)resource.getMetadata());
        if (Watcher.Action.ERROR == action) {
            log.error("Received error for resource: {}", (Object)resource.getMetadata().getName());
            return;
        }
        if (this.markedForDeletion(resource) || action == Watcher.Action.DELETED) {
            boolean removeFinalizer = this.controller.deleteResource(resource);
            if (removeFinalizer && this.hasDefaultFinalizer(resource)) {
                log.debug("Removing finalizer on {}: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata());
                this.removeDefaultFinalizer(resource);
            }
        } else {
            Optional<CustomResource> updateResult = this.controller.createOrUpdateResource(resource);
            if (updateResult.isPresent()) {
                log.debug("Updating resource: {} with version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
                log.trace("Resource before update: {}", (Object)resource);
                CustomResource updatedResource = updateResult.get();
                this.addFinalizerIfNotPresent(updatedResource);
                this.replace(updatedResource);
                log.trace("Resource after update: {}", (Object)resource);
            } else if (!this.hasDefaultFinalizer(resource) && !this.markedForDeletion(resource)) {
                log.debug("Adding finalizer for resource: {} version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
                this.addFinalizerIfNotPresent(resource);
                this.replace(resource);
            }
        }
    }

    private boolean hasDefaultFinalizer(CustomResource resource) {
        if (resource.getMetadata().getFinalizers() != null) {
            return resource.getMetadata().getFinalizers().contains(this.resourceDefaultFinalizer);
        }
        return false;
    }

    private void removeDefaultFinalizer(CustomResource resource) {
        resource.getMetadata().getFinalizers().remove(this.resourceDefaultFinalizer);
        log.debug("Removed finalizer. Trying to replace resource {}, version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
        this.customResourceReplaceFacade.replaceWithLock(resource);
    }

    private void replace(CustomResource resource) {
        log.debug("Trying to replace resource {}, version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
        this.customResourceReplaceFacade.replaceWithLock(resource);
    }

    private void addFinalizerIfNotPresent(CustomResource resource) {
        if (!this.hasDefaultFinalizer(resource) && !this.markedForDeletion(resource)) {
            log.info("Adding default finalizer to {}", (Object)resource.getMetadata());
            if (resource.getMetadata().getFinalizers() == null) {
                resource.getMetadata().setFinalizers(new ArrayList(1));
            }
            resource.getMetadata().getFinalizers().add(this.resourceDefaultFinalizer);
        }
    }

    private boolean markedForDeletion(CustomResource resource) {
        return resource.getMetadata().getDeletionTimestamp() != null && !resource.getMetadata().getDeletionTimestamp().isEmpty();
    }

    public static class CustomResourceReplaceFacade {
        private final MixedOperation<?, ?, ?, Resource<CustomResource, ?>> resourceOperation;

        public CustomResourceReplaceFacade(MixedOperation<?, ?, ?, Resource<CustomResource, ?>> resourceOperation) {
            this.resourceOperation = resourceOperation;
        }

        public CustomResource replaceWithLock(CustomResource resource) {
            return (CustomResource)((Replaceable)((Resource)((NonNamespaceOperation)this.resourceOperation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).lockResourceVersion(resource.getMetadata().getResourceVersion())).replace((Object)resource);
        }
    }
}

