/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator;

import com.github.containersolutions.operator.Context;
import com.github.containersolutions.operator.api.ResourceController;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceDoneable;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher<R extends CustomResource>
implements Watcher<R> {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private final ResourceController<R> controller;
    private final CustomResourceOperationsImpl<R, CustomResourceList<R>, CustomResourceDoneable<R>> resourceOperation;
    private final String resourceDefaultFinalizer;
    private final NonNamespaceOperation<R, CustomResourceList<R>, CustomResourceDoneable<R>, Resource<R, CustomResourceDoneable<R>>> resourceClient;
    private final KubernetesClient k8sClient;

    public EventDispatcher(ResourceController<R> controller, CustomResourceOperationsImpl<R, CustomResourceList<R>, CustomResourceDoneable<R>> resourceOperation, NonNamespaceOperation<R, CustomResourceList<R>, CustomResourceDoneable<R>, Resource<R, CustomResourceDoneable<R>>> resourceClient, KubernetesClient k8sClient, String defaultFinalizer) {
        this.controller = controller;
        this.resourceOperation = resourceOperation;
        this.resourceClient = resourceClient;
        this.resourceDefaultFinalizer = defaultFinalizer;
        this.k8sClient = k8sClient;
    }

    @Override
    public void eventReceived(Watcher.Action action, R resource) {
        try {
            log.debug("Action: {}, {}: {}, Resource: {}", new Object[]{action, resource.getClass().getSimpleName(), ((CustomResource)resource).getMetadata().getName(), resource});
            this.handleEvent(action, resource);
            log.trace("Even handling finished for action: {} resource: {}", (Object)action, (Object)resource);
        }
        catch (RuntimeException e) {
            log.error("Error on resource: {}", (Object)((CustomResource)resource).getMetadata().getName(), (Object)e);
        }
    }

    private void handleEvent(Watcher.Action action, R resource) {
        if (action == Watcher.Action.MODIFIED || action == Watcher.Action.ADDED) {
            if (this.markedForDeletion(resource) && this.hasDefaultFinalizer(resource)) {
                boolean removeFinalizer = this.controller.deleteResource(resource, new Context<R>(this.k8sClient, this.resourceClient));
                if (removeFinalizer) {
                    this.removeDefaultFinalizer(resource);
                }
            } else {
                Optional<R> updateResult = this.controller.createOrUpdateResource(resource, new Context<R>(this.k8sClient, this.resourceClient));
                if (updateResult.isPresent()) {
                    CustomResource updatedResource = (CustomResource)updateResult.get();
                    this.addFinalizerIfNotPresent(updatedResource);
                    this.replace(updatedResource);
                } else if (!this.hasDefaultFinalizer(resource) && !this.markedForDeletion(resource)) {
                    this.addFinalizerIfNotPresent(resource);
                    this.replace(resource);
                }
            }
        }
        if (Watcher.Action.ERROR == action) {
            log.error("Received error for resource: {}", (Object)((CustomResource)resource).getMetadata().getName());
        }
        if (Watcher.Action.DELETED == action) {
            log.debug("Resource deleted: {}", (Object)((CustomResource)resource).getMetadata().getName());
        }
    }

    private boolean hasDefaultFinalizer(R resource) {
        if (((CustomResource)resource).getMetadata().getFinalizers() != null) {
            return ((CustomResource)resource).getMetadata().getFinalizers().contains(this.resourceDefaultFinalizer);
        }
        return false;
    }

    private void removeDefaultFinalizer(R resource) {
        ((CustomResource)resource).getMetadata().getFinalizers().remove(this.resourceDefaultFinalizer);
        this.resourceOperation.lockResourceVersion(((CustomResource)resource).getMetadata().getResourceVersion()).replace(resource);
    }

    private void replace(R resource) {
        this.resourceOperation.lockResourceVersion(((CustomResource)resource).getMetadata().getResourceVersion()).replace(resource);
    }

    private void addFinalizerIfNotPresent(R resource) {
        if (!this.hasDefaultFinalizer(resource)) {
            if (((CustomResource)resource).getMetadata().getFinalizers() == null) {
                ((CustomResource)resource).getMetadata().setFinalizers(new ArrayList<String>(1));
            }
            ((CustomResource)resource).getMetadata().getFinalizers().add(this.resourceDefaultFinalizer);
        }
    }

    private boolean markedForDeletion(R resource) {
        return ((CustomResource)resource).getMetadata().getDeletionTimestamp() != null && !((CustomResource)resource).getMetadata().getDeletionTimestamp().isEmpty();
    }

    @Override
    public void onClose(KubernetesClientException e) {
        if (e != null) {
            log.error("Error: ", e);
            System.exit(1);
        }
    }
}

