/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.sample;

import com.github.containersolutions.operator.Context;
import com.github.containersolutions.operator.api.Controller;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.sample.WebServer;
import com.github.containersolutions.operator.sample.WebServerDoneable;
import com.github.containersolutions.operator.sample.WebServerList;
import com.github.containersolutions.operator.sample.WebServerStatus;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(customResourceClass=WebServer.class, kind="WebServer", group="sample.javaoperatorsdk", customResourceListClass=WebServerList.class, customResourceDonebaleClass=WebServerDoneable.class)
public class WebServerController
implements ResourceController<WebServer> {
    static final String KIND = "WebServer";
    static final String GROUP = "sample.javaoperatorsdk";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Optional<WebServer> createOrUpdateResource(WebServer webServer, Context<WebServer> context) {
        this.log.info("Execution createOrUpdateResource for: {} in {}", (Object)webServer.getMetadata().getName(), (Object)webServer.getMetadata().getNamespace());
        String ns = webServer.getMetadata().getNamespace();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("index.html", webServer.getSpec().getHtml());
        ConfigMap htmlConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(WebServerController.configMapName(webServer))).withNamespace(ns)).build())).withData(data)).build();
        Deployment deployment = this.loadYaml(Deployment.class, "deployment.yaml");
        deployment.getMetadata().setName(WebServerController.deploymentName(webServer));
        deployment.getMetadata().setNamespace(ns);
        deployment.getSpec().getSelector().getMatchLabels().put("app", WebServerController.deploymentName(webServer));
        deployment.getSpec().getTemplate().getMetadata().getLabels().put("app", WebServerController.deploymentName(webServer));
        deployment.getSpec().getTemplate().getSpec().getVolumes().get(0).setConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(WebServerController.configMapName(webServer))).build());
        Service service = this.loadYaml(Service.class, "service.yaml");
        service.getMetadata().setName(WebServerController.serviceName(webServer));
        service.getMetadata().setNamespace(ns);
        service.getSpec().setSelector(deployment.getSpec().getTemplate().getMetadata().getLabels());
        ConfigMap existingConfigMap = (ConfigMap)((Resource)((NonNamespaceOperation)context.getK8sClient().configMaps().inNamespace(htmlConfigMap.getMetadata().getNamespace())).withName(htmlConfigMap.getMetadata().getName())).get();
        this.log.info("Creating or updating ConfigMap {} in {}", (Object)htmlConfigMap.getMetadata().getName(), (Object)ns);
        ((NonNamespaceOperation)context.getK8sClient().configMaps().inNamespace(ns)).createOrReplace(htmlConfigMap);
        this.log.info("Creating or updating Deployment {} in {}", (Object)deployment.getMetadata().getName(), (Object)ns);
        ((NonNamespaceOperation)context.getK8sClient().apps().deployments().inNamespace(ns)).createOrReplace(deployment);
        if (((ServiceResource)((NonNamespaceOperation)context.getK8sClient().services().inNamespace(ns)).withName(service.getMetadata().getName())).get() == null) {
            this.log.info("Creating Service {} in {}", (Object)service.getMetadata().getName(), (Object)ns);
            ((NonNamespaceOperation)context.getK8sClient().services().inNamespace(ns)).createOrReplace(service);
        }
        if (existingConfigMap != null && !StringUtils.equals(existingConfigMap.getData().get("index.html"), htmlConfigMap.getData().get("index.html"))) {
            this.log.info("Restarting pods because HTML has changed in {}", (Object)ns);
            ((FilterWatchListDeletable)((NonNamespaceOperation)context.getK8sClient().pods().inNamespace(ns)).withLabel("app", WebServerController.deploymentName(webServer))).delete();
        }
        WebServerStatus status = new WebServerStatus();
        status.setHtmlConfigMap(htmlConfigMap.getMetadata().getName());
        status.setAreWeGood("Yes!");
        webServer.setStatus(status);
        return Optional.of(webServer);
    }

    @Override
    public boolean deleteResource(WebServer nginx, Context<WebServer> context) {
        this.log.info("Execution deleteResource for: {}", (Object)nginx.getMetadata().getName());
        this.log.info("Deleting ConfigMap {}", (Object)WebServerController.configMapName(nginx));
        Resource configMap = (Resource)((NonNamespaceOperation)context.getK8sClient().configMaps().inNamespace(nginx.getMetadata().getNamespace())).withName(WebServerController.configMapName(nginx));
        if (configMap.get() != null) {
            configMap.delete();
        }
        this.log.info("Deleting Deployment {}", (Object)WebServerController.deploymentName(nginx));
        RollableScalableResource deployment = (RollableScalableResource)((NonNamespaceOperation)context.getK8sClient().apps().deployments().inNamespace(nginx.getMetadata().getNamespace())).withName(WebServerController.deploymentName(nginx));
        if (deployment.get() != null) {
            ((EditReplacePatchDeletable)deployment.cascading(true)).delete();
        }
        this.log.info("Deleting Service {}", (Object)WebServerController.serviceName(nginx));
        ServiceResource service = (ServiceResource)((NonNamespaceOperation)context.getK8sClient().services().inNamespace(nginx.getMetadata().getNamespace())).withName(WebServerController.serviceName(nginx));
        if (service.get() != null) {
            service.delete();
        }
        return true;
    }

    private static String configMapName(WebServer nginx) {
        return nginx.getMetadata().getName() + "-html";
    }

    private static String deploymentName(WebServer nginx) {
        return nginx.getMetadata().getName();
    }

    private static String serviceName(WebServer nginx) {
        return nginx.getMetadata().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T loadYaml(Class<T> clazz, String yaml) {
        try (InputStream is = this.getClass().getResourceAsStream(yaml);){
            T t = Serialization.unmarshal(is, clazz);
            return t;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot find yaml on classpath: " + yaml);
        }
    }
}

