/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public interface ResourceHandler<T, V extends VisitableBuilder<T, V>> {
    public String getKind();

    public String getApiVersion();

    public T create(OkHttpClient var1, Config var2, String var3, T var4);

    public T replace(OkHttpClient var1, Config var2, String var3, T var4);

    public T reload(OkHttpClient var1, Config var2, String var3, T var4);

    public V edit(T var1);

    public Boolean delete(OkHttpClient var1, Config var2, String var3, T var4);

    public Watch watch(OkHttpClient var1, Config var2, String var3, T var4, Watcher<T> var5);

    public Watch watch(OkHttpClient var1, Config var2, String var3, T var4, String var5, Watcher<T> var6);

    public T waitUntilReady(OkHttpClient var1, Config var2, String var3, T var4, long var5, TimeUnit var7) throws InterruptedException;

    public T waitUntilCondition(OkHttpClient var1, Config var2, String var3, T var4, Predicate<T> var5, long var6, TimeUnit var8) throws InterruptedException;

    public static class Key {
        private final String kind;
        private final String apiVersion;
        private final String repr;

        public Key(String kind, String apiVersion) {
            this.kind = kind;
            this.apiVersion = apiVersion;
            this.repr = String.format("Key[kind=`%s`, apiVersion=`%s`]", this.kind, this.apiVersion);
        }

        public String getKind() {
            return this.kind;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String toString() {
            return this.repr;
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.apiVersion);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.getKind().equals(other.getKind()) && this.getApiVersion().equals(other.getApiVersion());
        }
    }
}

