/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.client.utils.BlockingInputStreamPumper;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>>
implements PodResource<Pod, DoneablePod>,
CopyOrReadable<Boolean, InputStream> {
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    private final String containerId;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final OutputStream errChannel;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final PipedInputStream errChannelPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final ExecListener execListener;
    private final Integer limitBytes;
    private final Integer bufferSize;

    public PodOperationsImpl(OkHttpClient client, Config config) {
        this(new PodOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public PodOperationsImpl(PodOperationContext context) {
        super(context.withPlural("pods"));
        this.type = Pod.class;
        this.listType = PodList.class;
        this.doneableType = DoneablePod.class;
        this.containerId = context.getContainerId();
        this.in = context.getIn();
        this.inPipe = context.getInPipe();
        this.out = context.getOut();
        this.outPipe = context.getOutPipe();
        this.err = context.getErr();
        this.errPipe = context.getErrPipe();
        this.errChannel = context.getErrChannel();
        this.errChannelPipe = context.getErrChannelPipe();
        this.withTTY = context.isTty();
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.execListener = context.getExecListener();
        this.limitBytes = context.getLimitBytes();
        this.bufferSize = context.getBufferSize();
    }

    public PodOperationsImpl newInstance(OperationContext context) {
        return new PodOperationsImpl((PodOperationContext)context);
    }

    public PodOperationContext getContext() {
        return (PodOperationContext)this.context;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected ResponseBody doGetLog() {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters()));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            ResponseBody body = response.body();
            this.assertResponseCode(request, response);
            return body;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLog() {
        try (ResponseBody body = this.doGetLog();){
            String string = body.string();
            return string;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("getLog"), (Throwable)e);
        }
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog().charStream();
    }

    @Override
    public String getLog(Boolean isPretty) {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(isPretty)).getLog();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"));
            Request request = new Request.Builder().url(url).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue(callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), t);
        }
    }

    @Override
    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port, in, out);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port, int localPort) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port, localPort);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ContainerResource<String, LogWatch, InputStream, PipedOutputStream, OutputStream, PipedInputStream, String, ExecWatch, Boolean, InputStream> inContainer(String containerId) {
        return new PodOperationsImpl(this.getContext().withContainerId(containerId));
    }

    public ExecWatch exec(String ... command) {
        StringBuilder sb = new StringBuilder();
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        sb.append("exec?command=");
        boolean first = true;
        for (String cmd : actualCommands) {
            if (first) {
                first = false;
            } else {
                sb.append("&command=");
            }
            try {
                cmd = URLUtils.encodeToUTF(cmd);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb.append(cmd);
        }
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTTY) {
            sb.append("&tty=true");
        }
        if (this.in != null || this.inPipe != null) {
            sb.append("&stdin=true");
        }
        if (this.out != null || this.outPipe != null) {
            sb.append("&stdout=true");
        }
        if (this.err != null || this.errPipe != null) {
            sb.append("&stderr=true");
        }
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), sb.toString()));
            Request.Builder r = new Request.Builder().url(url).header("Sec-WebSocket-Protocol", "v4.channel.k8s.io").get();
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.getConfig(), this.in, this.out, this.err, this.errChannel, this.inPipe, this.outPipe, this.errPipe, this.errChannelPipe, this.execListener, this.bufferSize);
            clone.newWebSocket(r.build(), execWebSocketListener);
            execWebSocketListener.waitUntilReady();
            return execWebSocketListener;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("exec"), t);
        }
    }

    @Override
    public CopyOrReadable<Boolean, InputStream> file(String file) {
        return new PodOperationsImpl(this.getContext().withFile(file));
    }

    @Override
    public CopyOrReadable<Boolean, InputStream> dir(String dir) {
        return new PodOperationsImpl(this.getContext().withDir(dir));
    }

    @Override
    public Boolean copy(Path destination) {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                this.copyFile(this.getContext().getFile(), destination.toFile());
                return true;
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                this.copyDir(this.getContext().getFile(), destination.toFile());
                return true;
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public InputStream read() {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                return this.readFile(this.getContext().getFile());
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                return this.readTar(this.getContext().getFile());
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private InputStream readFile(final String source) {
        try {
            return new Callable<InputStream>(){

                @Override
                public InputStream call() {
                    try {
                        final PipedOutputStream out = new PipedOutputStream();
                        PipedInputStream in = new PipedInputStream(out, 1024);
                        ExecWatch watch = (ExecWatch)((Execable)PodOperationsImpl.this.writingOutput(out).usingListener(new ExecListener(){

                            @Override
                            public void onOpen(Response response) {
                            }

                            @Override
                            public void onFailure(Throwable t, Response response) {
                            }

                            @Override
                            public void onClose(int code, String reason) {
                                try {
                                    out.flush();
                                    out.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        })).exec("sh", "-c", "cat " + source + "|base64");
                        return new Base64InputStream((InputStream)in);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                }
            }.call();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("Base64InputStream class is provided by commons-codec, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    private void copyFile(final String source, final File target) {
        try {
            new Runnable(){

                @Override
                public void run() {
                    File destination = target;
                    if (!(destination.exists() || destination.getParentFile().exists() || destination.getParentFile().mkdirs())) {
                        throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination.getParentFile()));
                    }
                    if (destination.isDirectory()) {
                        String[] parts = source.split("\\/|\\\\");
                        String filename = parts[parts.length - 1];
                        destination = destination.toPath().resolve(filename).toFile();
                    }
                    try (InputStream is = PodOperationsImpl.this.readFile(source);
                         FileOutputStream os = new FileOutputStream(destination);){
                        BlockingInputStreamPumper pumper = new BlockingInputStreamPumper(is, input -> {
                            try {
                                os.write((byte[])input);
                            }
                            catch (IOException e) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                        }, () -> {
                            try {
                                os.flush();
                            }
                            catch (Exception e) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                        });
                        pumper.run();
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                }
            }.run();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("Base64InputStream class is provided by commons-codec, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    public InputStream readTar(final String source) throws Exception {
        try {
            return new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    try {
                        final PipedOutputStream out = new PipedOutputStream();
                        PipedInputStream in = new PipedInputStream(out, 1024);
                        ExecWatch watch = (ExecWatch)((Execable)PodOperationsImpl.this.writingOutput(out).usingListener(new ExecListener(){

                            @Override
                            public void onOpen(Response response) {
                            }

                            @Override
                            public void onFailure(Throwable t, Response response) {
                            }

                            @Override
                            public void onClose(int code, String reason) {
                                try {
                                    out.flush();
                                    out.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        })).exec("sh", "-c", "tar -cf - " + source + "|base64");
                        return new Base64InputStream((InputStream)in);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                    catch (NoClassDefFoundError n) {
                        throw KubernetesClientException.launderThrowable(n);
                    }
                }
            }.call();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("Base64InputStream class is provided by commons-codec, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    private void copyDir(final String source, final File target) throws Exception {
        try {
            new Runnable(){

                @Override
                public void run() {
                    File destination = target;
                    if (!destination.isDirectory() && !destination.mkdirs()) {
                        throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination));
                    }
                    try (InputStream is = PodOperationsImpl.this.readTar(source);
                         FileOutputStream os = new FileOutputStream(destination);
                         TarArchiveInputStream tis = new TarArchiveInputStream(is);){
                        TarArchiveEntry entry = tis.getNextTarEntry();
                        while (entry != null) {
                            if (tis.canReadEntryData((ArchiveEntry)entry)) {
                                File f = new File(destination, entry.getName());
                                if (entry.isDirectory()) {
                                    if (!f.isDirectory() && !f.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                } else {
                                    File parent = f.getParentFile();
                                    if (!parent.isDirectory() && !parent.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                    try (final FileOutputStream fs = new FileOutputStream(f);){
                                        System.out.println("Writing: " + f.getCanonicalPath());
                                        BlockingInputStreamPumper pumper = new BlockingInputStreamPumper((InputStream)tis, new Callback<byte[]>(){

                                            @Override
                                            public void call(byte[] input) {
                                                try {
                                                    fs.write(input);
                                                }
                                                catch (IOException e) {
                                                    throw KubernetesClientException.launderThrowable(e);
                                                }
                                            }
                                        }, () -> {
                                            try {
                                                fs.close();
                                            }
                                            catch (IOException e) {
                                                throw KubernetesClientException.launderThrowable(e);
                                            }
                                        });
                                        pumper.run();
                                    }
                                }
                            }
                            entry = tis.getNextEntry();
                        }
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                }
            }.run();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("TarArchiveInputStream class is provided by commons-codec, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingInput(InputStream in) {
        return new PodOperationsImpl(this.getContext().withIn(in));
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingInput(PipedOutputStream inPipe) {
        return new PodOperationsImpl(this.getContext().withInPipe(inPipe));
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput() {
        return this.redirectingInput(null);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput(Integer bufferSize) {
        return new PodOperationsImpl(this.getContext().withBufferSize(bufferSize));
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingOutput(OutputStream out) {
        return new PodOperationsImpl(this.getContext().withOut(out));
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingOutput(PipedInputStream outPipe) {
        return new PodOperationsImpl(this.getContext().withOutPipe(outPipe));
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingOutput() {
        return this.readingOutput(new PipedInputStream());
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> writingError(OutputStream err) {
        return new PodOperationsImpl(this.getContext().withErr(err));
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> readingError(PipedInputStream errPipe) {
        return new PodOperationsImpl(this.getContext().withErrPipe(errPipe));
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> redirectingError() {
        return this.readingError(new PipedInputStream());
    }

    @Override
    public TtyExecable<String, ExecWatch> writingErrorChannel(OutputStream errChannel) {
        return new PodOperationsImpl(this.getContext().withErrChannel(errChannel));
    }

    @Override
    public TtyExecable<String, ExecWatch> readingErrorChannel(PipedInputStream errChannelPipe) {
        return new PodOperationsImpl(this.getContext().withErrChannelPipe(errChannelPipe));
    }

    @Override
    public TtyExecable<String, ExecWatch> redirectingErrorChannel() {
        return this.readingErrorChannel(new PipedInputStream());
    }

    @Override
    public ExecListenable<String, ExecWatch> withTTY() {
        return new PodOperationsImpl(this.getContext().withTty(true));
    }

    @Override
    public Loggable<String, LogWatch> withPrettyOutput() {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(true));
    }

    @Override
    public PrettyLoggable<String, LogWatch> tailingLines(int withTailingLines) {
        return new PodOperationsImpl(this.getContext().withTailingLines(withTailingLines));
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceTime(String sinceTimestamp) {
        return new PodOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp));
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceSeconds(int sinceSeconds) {
        return new PodOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds));
    }

    @Override
    public TimeTailPrettyLoggable<String, LogWatch> terminated() {
        return new PodOperationsImpl(this.getContext().withTerminatedStatus(true));
    }

    @Override
    public Execable<String, ExecWatch> usingListener(ExecListener execListener) {
        return new PodOperationsImpl(this.getContext().withExecListener(execListener));
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> limitBytes(int limitBytes) {
        return new PodOperationsImpl(this.getContext().withLimitBytes(limitBytes));
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> usingTimestamps() {
        return new PodOperationsImpl(this.getContext().withTimestamps(true));
    }
}

