/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserFluent;
import io.fabric8.openshift.api.model.UserFluentImpl;
import javax.validation.Validator;

public class UserBuilder
extends UserFluentImpl<UserBuilder>
implements VisitableBuilder<User, UserBuilder> {
    UserFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public UserBuilder() {
        this(true);
    }

    public UserBuilder(Boolean validationEnabled) {
        this(new User(), validationEnabled);
    }

    public UserBuilder(UserFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public UserBuilder(UserFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new User(), validationEnabled);
    }

    public UserBuilder(UserFluent<?> fluent, User instance) {
        this(fluent, instance, true);
    }

    public UserBuilder(UserFluent<?> fluent, User instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withFullName(instance.getFullName());
        fluent.withGroups(instance.getGroups());
        fluent.withIdentities(instance.getIdentities());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public UserBuilder(User instance) {
        this(instance, (Boolean)true);
    }

    public UserBuilder(User instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public UserBuilder(Validator validator) {
        this(new User(), (Boolean)true);
    }

    public UserBuilder(UserFluent<?> fluent, User instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withFullName(instance.getFullName());
        fluent.withGroups(instance.getGroups());
        fluent.withIdentities(instance.getIdentities());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public UserBuilder(User instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public User build() {
        User buildable = new User(this.fluent.getApiVersion(), this.fluent.getFullName(), this.fluent.getGroups(), this.fluent.getIdentities(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserBuilder that = (UserBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

