/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos;

public interface BiFunc<X, Y, Z> {
    public Z apply(X var1, Y var2) throws Exception;

    public static final class NoNulls<X, Y, Z>
    implements BiFunc<X, Y, Z> {
        private final BiFunc<X, Y, Z> origin;

        public NoNulls(BiFunc<X, Y, Z> func) {
            this.origin = func;
        }

        @Override
        public Z apply(X first, Y second) throws Exception {
            if (this.origin == null) {
                throw new IllegalArgumentException("NULL instead of a valid function");
            }
            if (first == null) {
                throw new IllegalArgumentException("NULL instead of a valid first argument");
            }
            if (second == null) {
                throw new IllegalArgumentException("NULL instead of a valid second argument");
            }
            Z result = this.origin.apply(first, second);
            if (result == null) {
                throw new IllegalStateException("NULL instead of a valid result");
            }
            return result;
        }
    }
}

