/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.collection;

import java.util.Collection;
import java.util.Iterator;
import org.cactoos.Scalar;
import org.cactoos.iterator.Immutable;
import org.cactoos.scalar.And;
import org.cactoos.scalar.Folded;
import org.cactoos.scalar.InheritanceLevel;
import org.cactoos.scalar.SumOfIntScalar;
import org.cactoos.scalar.UncheckedScalar;

public abstract class CollectionEnvelope<X>
implements Collection<X> {
    private final UncheckedScalar<Collection<X>> col;

    public CollectionEnvelope(Scalar<Collection<X>> slr) {
        this.col = new UncheckedScalar<Collection<X>>(slr);
    }

    @Override
    public final int size() {
        return this.col.value().size();
    }

    @Override
    public final boolean isEmpty() {
        return this.col.value().isEmpty();
    }

    @Override
    public final Iterator<X> iterator() {
        return new Immutable<X>(this.col.value().iterator());
    }

    @Override
    public final boolean contains(Object object) {
        return this.col.value().contains(object);
    }

    @Override
    public final Object[] toArray() {
        return this.col.value().toArray();
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        return this.col.value().toArray(array);
    }

    @Override
    public final boolean add(X item) {
        throw new UnsupportedOperationException("#add(): the collection is read-only");
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException("#remove(): the collection is read-only");
    }

    @Override
    public final boolean containsAll(Collection<?> list) {
        return this.col.value().containsAll(list);
    }

    @Override
    public final boolean addAll(Collection<? extends X> list) {
        throw new UnsupportedOperationException("#addAll(): the collection is read-only");
    }

    @Override
    public final boolean removeAll(Collection<?> list) {
        throw new UnsupportedOperationException("#removeAll(): the collection is read-only");
    }

    @Override
    public final boolean retainAll(Collection<?> list) {
        throw new UnsupportedOperationException("#retainAll(): the collection is read-only");
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException("#clear(): the collection is read-only");
    }

    public String toString() {
        return this.col.value().toString();
    }

    @Override
    public final boolean equals(Object other) {
        return new UncheckedScalar<Boolean>(new And(() -> other != null, () -> new InheritanceLevel(other.getClass(), CollectionEnvelope.class).value() > -1, () -> {
            Collection compared = (Collection)other;
            return this.size() == compared.size();
        }, () -> {
            Iterable compared = (Iterable)other;
            Iterator iterator = compared.iterator();
            return new UncheckedScalar<Boolean>(new And(input -> input.equals(iterator.next()), this)).value();
        })).value();
    }

    @Override
    public final int hashCode() {
        return (Integer)new UncheckedScalar(new Folded<Integer, Object>(Integer.valueOf(42), (hash, entry) -> {
            Scalar[] scalarArray = new Scalar[2];
            scalarArray[0] = () -> 37 * hash;
            scalarArray[1] = entry::hashCode;
            return new SumOfIntScalar(scalarArray).value();
        }, this)).value();
    }
}

