/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.collection;

import java.util.Collection;
import java.util.Iterator;
import org.cactoos.Func;
import org.cactoos.collection.CollectionEnvelope;
import org.cactoos.collection.CollectionOf;
import org.cactoos.iterable.IterableOf;
import org.cactoos.text.TextOf;

public final class Mapped<X, Y>
extends CollectionEnvelope<Y> {
    @SafeVarargs
    public Mapped(Func<X, Y> fnc, X ... src) {
        this(fnc, new IterableOf<X>(src));
    }

    public Mapped(Func<X, Y> fnc, Iterator<X> src) {
        this(fnc, new IterableOf<X>(src));
    }

    public Mapped(Func<X, Y> fnc, Iterable<X> src) {
        this(fnc, (Collection<X>)new CollectionOf<X>(src));
    }

    public Mapped(final Func<X, Y> fnc, final Collection<X> src) {
        super(() -> new Collection<Y>(){

            @Override
            public int size() {
                return src.size();
            }

            @Override
            public boolean isEmpty() {
                return src.isEmpty();
            }

            @Override
            public boolean contains(Object item) {
                return new CollectionOf(new org.cactoos.iterator.Mapped(fnc, src.iterator())).contains(item);
            }

            @Override
            public Iterator<Y> iterator() {
                return new org.cactoos.iterator.Mapped(fnc, src.iterator());
            }

            @Override
            public Object[] toArray() {
                return new CollectionOf(new org.cactoos.iterator.Mapped(fnc, src.iterator())).toArray();
            }

            @Override
            public <T> T[] toArray(T[] array) {
                return new CollectionOf<T>(new org.cactoos.iterator.Mapped(fnc, src.iterator())).toArray(array);
            }

            @Override
            public boolean add(Y item) {
                throw new UnsupportedOperationException("Collection is read-only, can't #add()");
            }

            @Override
            public boolean remove(Object item) {
                throw new UnsupportedOperationException("Collection is read-only, can't #remove()");
            }

            @Override
            public boolean containsAll(Collection<?> items) {
                return new CollectionOf(new org.cactoos.iterator.Mapped(fnc, src.iterator())).containsAll(items);
            }

            @Override
            public boolean addAll(Collection<? extends Y> items) {
                throw new UnsupportedOperationException("Collection is read-only, can't #addAll()");
            }

            @Override
            public boolean removeAll(Collection<?> items) {
                throw new UnsupportedOperationException("Collection is read-only, can't #removeAll()");
            }

            @Override
            public boolean retainAll(Collection<?> items) {
                throw new UnsupportedOperationException("Collection is read-only, can't #retainAll()");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Collection is read-only, can't #clear()");
            }
        });
    }

    @Override
    public String toString() {
        return new TextOf(this).toString();
    }
}

