/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import org.cactoos.Func;
import org.cactoos.Proc;
import org.cactoos.func.FuncOf;

public final class RetryFunc<X, Y>
implements Func<X, Y> {
    private final Func<X, Y> func;
    private final Func<Integer, Boolean> exit;

    public RetryFunc(Proc<X> proc) {
        this(new FuncOf<X, Object>(proc, null));
    }

    public RetryFunc(Proc<X> proc, int attempts) {
        this(new FuncOf<X, Object>(proc, null), attempts);
    }

    public RetryFunc(Proc<X> proc, Func<Integer, Boolean> ext) {
        this(new FuncOf<X, Object>(proc, null), ext);
    }

    public RetryFunc(Func<X, Y> fnc) {
        this(fnc, 3);
    }

    public RetryFunc(Func<X, Y> fnc, int attempts) {
        this(fnc, (Integer attempt) -> attempt >= attempts);
    }

    public RetryFunc(Func<X, Y> fnc, Func<Integer, Boolean> ext) {
        this.func = fnc;
        this.exit = ext;
    }

    @Override
    public Y apply(X input) throws Exception {
        int attempt = 0;
        Exception error = new IllegalArgumentException("An immediate exit, didn't have a chance to try at least once");
        while (!this.exit.apply(attempt).booleanValue()) {
            try {
                return this.func.apply(input);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                error = ex;
                break;
            }
            catch (Exception ex) {
                error = ex;
                ++attempt;
            }
        }
        throw error;
    }
}

