/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cactoos.BiFunc;
import org.cactoos.map.MapEntry;

public final class StickyBiFunc<X, Y, Z>
implements BiFunc<X, Y, Z> {
    private final BiFunc<X, Y, Z> func;
    private final Map<Map.Entry<X, Y>, Z> cache;
    private final int size;

    public StickyBiFunc(BiFunc<X, Y, Z> fnc) {
        this(fnc, Integer.MAX_VALUE);
    }

    public StickyBiFunc(BiFunc<X, Y, Z> fnc, int max) {
        this.func = fnc;
        this.cache = new LinkedHashMap<Map.Entry<X, Y>, Z>(0);
        this.size = max;
    }

    @Override
    public Z apply(X first, Y second) throws Exception {
        MapEntry<X, Y> key = new MapEntry<X, Y>(first, second);
        while (this.cache.size() > this.size) {
            this.cache.remove(this.cache.keySet().iterator().next());
        }
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, this.func.apply(first, second));
        }
        return this.cache.get(key);
    }
}

