/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.scalar.UncheckedScalar;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;

public final class LoggingInputStream
extends InputStream {
    private final InputStream origin;
    private final String source;
    private final Logger logger;
    private final AtomicLong bytes;
    private final AtomicLong time;
    private final UncheckedScalar<Level> level;

    public LoggingInputStream(InputStream input, String src) {
        this(input, src, Logger.getLogger(src));
    }

    public LoggingInputStream(InputStream input, String src, Logger lgr) {
        this.origin = input;
        this.source = src;
        this.logger = lgr;
        this.level = new UncheckedScalar<Level>(new StickyScalar<Level>(() -> {
            Level lvl = lgr.getLevel();
            if (lvl == null) {
                Logger parent = lgr;
                while (lvl == null) {
                    parent = parent.getParent();
                    lvl = parent.getLevel();
                }
            }
            return lvl;
        }));
        this.bytes = new AtomicLong();
        this.time = new AtomicLong();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        this.read(buf);
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        Instant start = Instant.now();
        int byts = this.origin.read(buf, offset, len);
        Instant end = Instant.now();
        long millis = Duration.between(start, end).toMillis();
        if (byts > 0) {
            this.bytes.getAndAdd(byts);
            this.time.getAndAdd(millis);
        }
        UncheckedText msg = new UncheckedText(new FormattedText("Read %d byte(s) from %s in %dms.", this.bytes.get(), this.source, this.time.get()));
        if (byts > 0) {
            if (!this.level.value().equals(Level.INFO)) {
                this.logger.log(this.level.value(), msg.asString());
            }
        } else if (this.level.value().equals(Level.INFO)) {
            this.logger.info(msg.asString());
        }
        return byts;
    }

    @Override
    public long skip(long num) throws IOException {
        long skipped = this.origin.skip(num);
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText("Skipped %d byte(s) from %s.", skipped, this.source)).asString());
        return skipped;
    }

    @Override
    public int available() throws IOException {
        int avail = this.origin.available();
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText("There is(are) %d byte(s) available from %s.", avail, this.source)).asString());
        return avail;
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText("Closed input stream from %s.", this.source)).asString());
    }

    @Override
    public void mark(int limit) {
        this.origin.mark(limit);
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText("Marked position %d from %s.", limit, this.source)).asString());
    }

    @Override
    public void reset() throws IOException {
        this.origin.reset();
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText("Reset input stream from %s.", this.source)).asString());
    }

    @Override
    public boolean markSupported() {
        boolean supported = this.origin.markSupported();
        String msg = supported ? "Mark and reset are supported from %s" : "Mark and reset NOT supported from %s";
        this.logger.log(this.level.value(), new UncheckedText(new FormattedText(msg, this.source)).asString());
        return supported;
    }
}

