/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.cactoos.Output;
import org.cactoos.Scalar;
import org.cactoos.io.OutputTo;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.scalar.UncheckedScalar;

public final class OutputStreamTo
extends OutputStream {
    private final UncheckedScalar<OutputStream> target;

    public OutputStreamTo(Path path) {
        this(new OutputTo(path));
    }

    public OutputStreamTo(File file) {
        this(new OutputTo(file));
    }

    public OutputStreamTo(Writer wtr) {
        this(wtr, StandardCharsets.UTF_8);
    }

    public OutputStreamTo(Writer wtr, Charset charset) {
        this(new OutputTo(wtr, charset));
    }

    public OutputStreamTo(Writer wtr, CharSequence charset) {
        this(new OutputTo(wtr, charset));
    }

    public OutputStreamTo(Writer wtr, Charset charset, int size) {
        this(new OutputTo(wtr, charset, size));
    }

    public OutputStreamTo(Writer wtr, CharSequence charset, int size) {
        this(new OutputTo(wtr, charset, size));
    }

    public OutputStreamTo(Writer wtr, CharsetDecoder ddr, int size) {
        this(new OutputTo(wtr, ddr, size));
    }

    public OutputStreamTo(Output output) {
        this(output::stream);
    }

    private OutputStreamTo(Scalar<OutputStream> tgt) {
        this.target = new UncheckedScalar<OutputStream>(new StickyScalar<OutputStream>(tgt));
    }

    @Override
    public void write(int data) throws IOException {
        this.target.value().write(data);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.target.value().write(buffer);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.target.value().write(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.target.value().close();
    }

    @Override
    public void flush() throws IOException {
        this.target.value().flush();
    }
}

