/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class IteratorOfDoubles
implements Iterator<Double> {
    private final double[] items;
    private final AtomicInteger position;

    public IteratorOfDoubles(double ... itms) {
        this.items = itms;
        this.position = new AtomicInteger(0);
    }

    @Override
    public boolean hasNext() {
        return this.position.intValue() < this.items.length;
    }

    @Override
    public Double next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return this.items[this.position.getAndIncrement()];
    }
}

