/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SyncIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final ReadWriteLock lock;

    public SyncIterator(Iterator<T> iterator) {
        this(iterator, new ReentrantReadWriteLock());
    }

    public SyncIterator(Iterator<T> iterator, ReadWriteLock lock) {
        this.iterator = iterator;
        this.lock = lock;
    }

    @Override
    public boolean hasNext() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.iterator.hasNext();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T next() {
        this.lock.writeLock().lock();
        try {
            T t = this.iterator.next();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

