/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cactoos.Func;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Joined;
import org.cactoos.iterable.Mapped;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapEnvelope;

public final class MapOf<X, Y>
extends MapEnvelope<X, Y> {
    @SafeVarargs
    public MapOf(Map.Entry<X, Y> ... list) {
        this(new IterableOf<Map.Entry<X, Y>>(list));
    }

    @SafeVarargs
    public MapOf(Map<X, Y> src, Map.Entry<X, Y> ... list) {
        this(src, new IterableOf<Map.Entry<X, Y>>(list));
    }

    public <Z> MapOf(Func<Z, X> key, Func<Z, Y> value, Iterable<Z> list) {
        this((Z item) -> new MapEntry(key.apply(item), value.apply(item)), list);
    }

    public <Z> MapOf(Func<Z, X> key, Func<Z, Y> value, Map<X, Y> src, Iterable<Z> list) {
        this((Z item) -> new MapEntry(key.apply(item), value.apply(item)), src, list);
    }

    public <Z> MapOf(Func<Z, Map.Entry<X, Y>> entry, Iterable<Z> list) {
        this(new Mapped<Z, Map.Entry<X, Y>>(entry, list));
    }

    public <Z> MapOf(Func<Z, Map.Entry<X, Y>> entry, Map<X, Y> src, Iterable<Z> list) {
        this(src, new Mapped<Z, Map.Entry<X, Y>>(entry, list));
    }

    public MapOf(Map<X, Y> src, Iterable<Map.Entry<X, Y>> list) {
        this(new Joined<Map.Entry<X, Y>>(src.entrySet(), list));
    }

    public MapOf(Iterable<Map.Entry<X, Y>> entries) {
        super(() -> {
            HashMap temp = new HashMap(0);
            for (Map.Entry entry : entries) {
                temp.put(entry.getKey(), entry.getValue());
            }
            return Collections.unmodifiableMap(temp);
        });
    }
}

