/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cactoos.Func;
import org.cactoos.Proc;
import org.cactoos.Scalar;
import org.cactoos.func.FuncOf;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Mapped;
import org.cactoos.scalar.And;
import org.cactoos.text.FormattedText;

public final class AndInThreads
implements Scalar<Boolean> {
    private final ExecutorService service;
    private final Iterable<Scalar<Boolean>> iterable;
    private final boolean shut;

    @SafeVarargs
    public <X> AndInThreads(Proc<X> proc, X ... src) {
        this(new FuncOf<X, Boolean>(proc, Boolean.valueOf(true)), src);
    }

    @SafeVarargs
    public <X> AndInThreads(Func<X, Boolean> func, X ... src) {
        this(func, (Iterable<X>)new IterableOf<X>(src));
    }

    public <X> AndInThreads(Proc<X> proc, Iterable<X> src) {
        this((Func<X, Boolean>)new FuncOf<X, Boolean>(proc, Boolean.valueOf(true)), src);
    }

    public <X> AndInThreads(Func<X, Boolean> func, Iterable<X> src) {
        this(new Mapped<Object, Scalar>(item -> () -> (Boolean)func.apply(item), src));
    }

    @SafeVarargs
    public AndInThreads(Scalar<Boolean> ... src) {
        this(new IterableOf<Scalar<Boolean>>(src));
    }

    public AndInThreads(Iterable<Scalar<Boolean>> src) {
        this(Executors.newCachedThreadPool(), src, true);
    }

    @SafeVarargs
    public <X> AndInThreads(ExecutorService svc, Proc<X> proc, X ... src) {
        this(svc, new FuncOf<X, Boolean>(proc, Boolean.valueOf(true)), src);
    }

    @SafeVarargs
    public <X> AndInThreads(ExecutorService svc, Func<X, Boolean> func, X ... src) {
        this(svc, func, (Iterable<X>)new IterableOf<X>(src));
    }

    public <X> AndInThreads(ExecutorService svc, Proc<X> proc, Iterable<X> src) {
        this(svc, (Func<X, Boolean>)new FuncOf<X, Boolean>(proc, Boolean.valueOf(true)), src);
    }

    public <X> AndInThreads(ExecutorService svc, Func<X, Boolean> func, Iterable<X> src) {
        this(svc, new Mapped<Object, Scalar>(item -> () -> (Boolean)func.apply(item), src));
    }

    @SafeVarargs
    public AndInThreads(ExecutorService svc, Scalar<Boolean> ... src) {
        this(svc, new IterableOf<Scalar<Boolean>>(src));
    }

    public AndInThreads(ExecutorService svc, Iterable<Scalar<Boolean>> src) {
        this(svc, src, false);
    }

    private AndInThreads(ExecutorService svc, Iterable<Scalar<Boolean>> src, boolean sht) {
        this.service = svc;
        this.iterable = src;
        this.shut = sht;
    }

    @Override
    public Boolean value() throws Exception {
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        for (Scalar<Boolean> item : this.iterable) {
            futures.add(this.service.submit(item::value));
        }
        boolean result = new And(Future::get, futures).value();
        if (this.shut) {
            this.service.shutdown();
            try {
                if (!this.service.awaitTermination(1L, TimeUnit.MINUTES)) {
                    throw new IllegalStateException(new FormattedText("Can't terminate the service, result=%b", result).asString());
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }
}

